/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.condition.Condition;
import org.h2.expression.condition.ConditionAndOr;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionLocalAndGlobal
extends Condition {
    private Expression local;
    private Expression global;

    public ConditionLocalAndGlobal(Expression expression, Expression expression2) {
        if (expression2 == null) {
            DbException.throwInternalError();
        }
        this.local = expression;
        this.global = expression2;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        if (this.local == null) {
            return this.global.getSQL(stringBuilder, bl);
        }
        stringBuilder.append('(');
        this.local.getSQL(stringBuilder, bl);
        stringBuilder.append("\n    _LOCAL_AND_GLOBAL_ ");
        return this.global.getSQL(stringBuilder, bl).append(')');
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (this.local != null) {
            this.local.createIndexConditions(session, tableFilter);
        }
        this.global.createIndexConditions(session, tableFilter);
    }

    @Override
    public Value getValue(Session session) {
        if (this.local == null) {
            return this.global.getValue(session);
        }
        Value value = this.local.getValue(session);
        if (value != ValueNull.INSTANCE && !value.getBoolean()) {
            return ValueBoolean.FALSE;
        }
        Value value2 = this.global.getValue(session);
        if (value2 != ValueNull.INSTANCE && !value2.getBoolean()) {
            return ValueBoolean.FALSE;
        }
        if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.TRUE;
    }

    @Override
    public Expression optimize(Session session) {
        this.global = this.global.optimize(session);
        if (this.local != null) {
            this.local = this.local.optimize(session);
            return ConditionAndOr.optimizeConstant(session, this, 0, this.local, this.global);
        }
        return this;
    }

    @Override
    public void addFilterConditions(TableFilter tableFilter) {
        if (this.local != null) {
            this.local.addFilterConditions(tableFilter);
        }
        this.global.addFilterConditions(tableFilter);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        if (this.local != null) {
            this.local.mapColumns(columnResolver, n, n2);
        }
        this.global.mapColumns(columnResolver, n, n2);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        if (this.local != null) {
            this.local.setEvaluatable(tableFilter, bl);
        }
        this.global.setEvaluatable(tableFilter, bl);
    }

    @Override
    public void updateAggregate(Session session, int n) {
        if (this.local != null) {
            this.local.updateAggregate(session, n);
        }
        this.global.updateAggregate(session, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return (this.local == null || this.local.isEverything(expressionVisitor)) && this.global.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        int n = this.global.getCost();
        if (this.local != null) {
            n += this.local.getCost();
        }
        return n;
    }

    @Override
    public int getSubexpressionCount() {
        return this.local == null ? 1 : 2;
    }

    @Override
    public Expression getSubexpression(int n) {
        switch (n) {
            case 0: {
                return this.local != null ? this.local : this.global;
            }
            case 1: {
                if (this.local == null) break;
                return this.global;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

