/*
 * Decompiled with CFR 0.152.
 */
package io.ebeanservice.docstore.api.mapping;

import io.ebean.annotation.DocMapping;
import io.ebean.core.type.DocPropertyType;
import io.ebeanservice.docstore.api.mapping.DocPropertyOptions;
import io.ebeanservice.docstore.api.mapping.DocPropertyVisitor;
import java.util.ArrayList;
import java.util.List;

public class DocPropertyMapping {
    private String name;
    private DocPropertyType type;
    private DocPropertyOptions options;
    private List<DocPropertyMapping> children = new ArrayList<DocPropertyMapping>();

    public DocPropertyMapping() {
        this.type = DocPropertyType.ROOT;
    }

    public DocPropertyMapping(String name, DocPropertyType type) {
        this.type = type;
        this.name = name;
        this.options = new DocPropertyOptions();
    }

    public DocPropertyMapping(String name, DocPropertyType type, DocPropertyOptions options) {
        this.name = name;
        this.type = type;
        this.options = options;
    }

    public void visit(DocPropertyVisitor visitor) {
        switch (this.type) {
            case ROOT: {
                visitor.visitBegin();
                this.visitChildren(visitor);
                visitor.visitEnd();
                break;
            }
            case OBJECT: {
                visitor.visitBeginObject(this);
                this.visitChildren(visitor);
                visitor.visitEndObject(this);
                break;
            }
            case LIST: {
                visitor.visitBeginList(this);
                this.visitChildren(visitor);
                visitor.visitEndList(this);
                break;
            }
            default: {
                visitor.visitProperty(this);
            }
        }
    }

    private void visitChildren(DocPropertyVisitor visitor) {
        for (DocPropertyMapping property : this.children) {
            property.visit(visitor);
        }
    }

    public String toString() {
        return "name:" + this.name + " type:" + (Object)((Object)this.type) + " options(" + this.options + ")";
    }

    public DocPropertyType getType() {
        return this.type;
    }

    public void setType(DocPropertyType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public DocPropertyOptions getOptions() {
        return this.options;
    }

    public List<DocPropertyMapping> getChildren() {
        return this.children;
    }

    public void addChild(DocPropertyMapping docMapping) {
        this.children.add(docMapping);
    }

    public void apply(DocMapping docMapping) {
        this.options.apply(docMapping);
    }
}

