/*
 * Decompiled with CFR 0.152.
 */
package io.ebeanservice.docstore.api.mapping;

import io.ebean.annotation.DocMapping;
import io.ebean.annotation.DocStore;
import io.ebean.text.PathProperties;
import io.ebean.util.SplitName;
import io.ebeanservice.docstore.api.mapping.DocPropertyAdapter;
import io.ebeanservice.docstore.api.mapping.DocPropertyMapping;
import io.ebeanservice.docstore.api.mapping.DocPropertyOptions;
import io.ebeanservice.docstore.api.mapping.DocumentMapping;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;

public class DocMappingBuilder {
    private final PathProperties paths;
    private final DocStore docStore;
    private final Stack<DocPropertyMapping> properties = new Stack();
    private final Map<String, DocPropertyMapping> map = new LinkedHashMap<String, DocPropertyMapping>();

    public DocMappingBuilder(PathProperties paths, DocStore docStore) {
        this.paths = paths;
        this.docStore = docStore;
        this.properties.push(new DocPropertyMapping());
    }

    public boolean includesProperty(String prefix, String name) {
        return this.paths.includesProperty(prefix, name);
    }

    public boolean includesPath(String prefix, String name) {
        return this.paths.includesProperty(prefix, name);
    }

    public void add(DocPropertyMapping docMapping) {
        DocPropertyMapping currentParent = this.properties.peek();
        currentParent.addChild(docMapping);
        String parentName = currentParent.getName();
        String fullName = SplitName.add(parentName, docMapping.getName());
        this.map.put(fullName, docMapping);
    }

    public void push(DocPropertyMapping nested) {
        this.properties.push(nested);
    }

    public void pop() {
        this.properties.pop();
    }

    public void applyMapping() {
        for (DocMapping docMapping : this.docStore.mapping()) {
            this.applyFieldMapping(docMapping);
        }
    }

    private void applyFieldMapping(DocMapping docMapping) {
        DocPropertyMapping mapping = this.map.get(docMapping.name());
        if (mapping == null) {
            throw new IllegalStateException("DocMapping for [" + docMapping.name() + "] but property not included in document?");
        }
        mapping.apply(docMapping);
    }

    public Map<String, String> collectSortable() {
        DocPropertyMapping peek = this.properties.peek();
        SortableVisitor visitor = new SortableVisitor();
        peek.visit(visitor);
        return visitor.getSortableMap();
    }

    public DocumentMapping create(String queueId, String indexName, String indexType) {
        int shards = this.docStore.shards();
        int replicas = this.docStore.replicas();
        DocPropertyMapping root = this.properties.peek();
        return new DocumentMapping(queueId, indexName, indexType, this.paths, root, shards, replicas);
    }

    private static class SortableVisitor
    extends DocPropertyAdapter {
        private Map<String, String> sortableMap = new LinkedHashMap<String, String>();

        private SortableVisitor() {
        }

        @Override
        public void visitProperty(DocPropertyMapping property) {
            DocPropertyOptions options = property.getOptions();
            if (options != null && options.isSortable()) {
                String fullPath = this.pathStack.peekFullPath(property.getName());
                this.sortableMap.put(fullPath, fullPath + ".raw");
            }
        }

        private Map<String, String> getSortableMap() {
            return this.sortableMap;
        }
    }
}

