/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.util;

import io.ebeaninternal.util.SortByClause;

public final class SortByClauseParser {
    private final String rawSortBy;

    public static SortByClause parse(String rawSortByClause) {
        return new SortByClauseParser(rawSortByClause).parse();
    }

    private SortByClauseParser(String rawSortByClause) {
        this.rawSortBy = rawSortByClause.trim();
    }

    private SortByClause parse() {
        String section;
        SortByClause.Property p;
        String[] sections;
        SortByClause sortBy = new SortByClause();
        String[] stringArray = sections = this.rawSortBy.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n && (p = this.parseSection((section = stringArray[i]).trim())) != null; ++i) {
            sortBy.add(p);
        }
        return sortBy;
    }

    private SortByClause.Property parseSection(String section) {
        if (section.isEmpty()) {
            return null;
        }
        String[] words = section.split(" ");
        if (words.length < 1 || words.length > 3) {
            throw new RuntimeException("Expecting 1 to 3 words in [" + section + "] but got [" + words.length + "]");
        }
        Boolean nullsHigh = null;
        boolean ascending = true;
        String propName = words[0];
        if (words.length > 1) {
            if (words[1].startsWith("nulls")) {
                nullsHigh = this.isNullsHigh(words[1]);
            } else {
                ascending = this.isAscending(words[1]);
            }
        }
        if (words.length > 2) {
            if (words[2].startsWith("nulls")) {
                nullsHigh = this.isNullsHigh(words[2]);
            } else {
                ascending = this.isAscending(words[2]);
            }
        }
        return new SortByClause.Property(propName, ascending, nullsHigh);
    }

    private Boolean isNullsHigh(String word) {
        if ("nullshigh".equalsIgnoreCase(word)) {
            return Boolean.TRUE;
        }
        if ("nullslow".equalsIgnoreCase(word)) {
            return Boolean.FALSE;
        }
        String m3 = "Expecting nullsHigh or nullsLow but got [" + word + "] in [" + this.rawSortBy + "]";
        throw new RuntimeException(m3);
    }

    private boolean isAscending(String word) {
        if ("asc".equalsIgnoreCase(word)) {
            return true;
        }
        if ("desc".equalsIgnoreCase(word)) {
            return false;
        }
        String m3 = "Expect ASC or DESC but got [" + word + "] in [" + this.rawSortBy + "]";
        throw new RuntimeException(m3);
    }
}

