/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.config.ScalarTypeConverter;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

public class ScalarTypeWrapper<B, S>
implements ScalarType<B> {
    private final ScalarType<S> scalarType;
    private final ScalarTypeConverter<B, S> converter;
    private final Class<B> wrapperType;
    private final B nullValue;

    public ScalarTypeWrapper(Class<B> wrapperType, ScalarType<S> scalarType, ScalarTypeConverter<B, S> converter) {
        this.scalarType = scalarType;
        this.converter = converter;
        this.nullValue = converter.getNullValue();
        this.wrapperType = wrapperType;
    }

    public String toString() {
        return "ScalarTypeWrapper " + this.wrapperType + " to " + this.scalarType.getType();
    }

    @Override
    public long asVersion(B value) {
        S unwrapValue = this.converter.unwrapValue(value);
        return this.scalarType.asVersion(unwrapValue);
    }

    @Override
    public boolean isBinaryType() {
        return this.scalarType.isBinaryType();
    }

    @Override
    public boolean isMutable() {
        return this.scalarType.isMutable();
    }

    @Override
    public boolean isDirty(Object value) {
        return this.scalarType.isDirty(value);
    }

    @Override
    public B readData(DataInput dataInput) throws IOException {
        S unwrapValue = this.scalarType.readData(dataInput);
        return this.converter.wrapValue(unwrapValue);
    }

    @Override
    public void writeData(DataOutput dataOutput, B value) throws IOException {
        S unwrapValue = this.converter.unwrapValue(value);
        this.scalarType.writeData(dataOutput, unwrapValue);
    }

    @Override
    public void bind(DataBinder binder, B value) throws SQLException {
        if (value == null) {
            this.scalarType.bind(binder, null);
        } else {
            S sv = this.converter.unwrapValue(value);
            this.scalarType.bind(binder, sv);
        }
    }

    @Override
    public int getJdbcType() {
        return this.scalarType.getJdbcType();
    }

    @Override
    public int getLength() {
        return this.scalarType.getLength();
    }

    @Override
    public Class<B> getType() {
        return this.wrapperType;
    }

    @Override
    public boolean isDateTimeCapable() {
        return this.scalarType.isDateTimeCapable();
    }

    @Override
    public boolean isJdbcNative() {
        return false;
    }

    @Override
    public String format(Object v) {
        return this.formatValue((B)v);
    }

    @Override
    public String formatValue(B v) {
        S sv = this.converter.unwrapValue(v);
        return this.scalarType.formatValue(sv);
    }

    @Override
    public B parse(String value) {
        S sv = this.scalarType.parse(value);
        if (sv == null) {
            return this.nullValue;
        }
        return this.converter.wrapValue(sv);
    }

    @Override
    public B convertFromMillis(long systemTimeMillis) {
        S sv = this.scalarType.convertFromMillis(systemTimeMillis);
        if (sv == null) {
            return this.nullValue;
        }
        return this.converter.wrapValue(sv);
    }

    @Override
    public void loadIgnore(DataReader reader) {
        reader.incrementPos(1);
    }

    @Override
    public B read(DataReader reader) throws SQLException {
        S sv = this.scalarType.read(reader);
        if (sv == null) {
            return this.nullValue;
        }
        return this.converter.wrapValue(sv);
    }

    @Override
    public B toBeanType(Object value) {
        if (value == null) {
            return this.nullValue;
        }
        if (this.getType().isAssignableFrom(value.getClass())) {
            return (B)value;
        }
        if (value instanceof String) {
            return this.parse((String)value);
        }
        S sv = this.scalarType.toBeanType(value);
        return this.converter.wrapValue(sv);
    }

    @Override
    public Object toJdbcType(Object value) {
        S sv = this.converter.unwrapValue(value);
        return this.scalarType.toJdbcType(sv);
    }

    public ScalarType<?> getScalarType() {
        return this;
    }

    @Override
    public B jsonRead(JsonParser parser) throws IOException {
        S object = this.scalarType.jsonRead(parser);
        return this.converter.wrapValue(object);
    }

    @Override
    public void jsonWrite(JsonGenerator writer, B beanValue) throws IOException {
        S unwrapValue = this.converter.unwrapValue(beanValue);
        this.scalarType.jsonWrite(writer, unwrapValue);
    }

    @Override
    public DocPropertyType getDocType() {
        return this.scalarType.getDocType();
    }
}

