/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.config.JsonConfig;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.IsoJsonDateTimeParser;
import io.ebeaninternal.server.type.ScalarTypeBaseDate;
import io.ebeaninternal.server.type.ScalarTypeBaseDateTime;
import io.ebeaninternal.server.type.UtilDateParser;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;

public class ScalarTypeUtilDate {

    public static class DateType
    extends ScalarTypeBaseDate<Date> {
        public DateType(JsonConfig.Date mode) {
            super(mode, Date.class, false, 91);
        }

        @Override
        protected String toIsoFormat(Date value) {
            return UtilDateParser.format(value);
        }

        @Override
        public long convertToMillis(Date value) {
            return value.getTime();
        }

        @Override
        public Date convertFromDate(java.sql.Date ts) {
            return new Date(ts.getTime());
        }

        @Override
        public java.sql.Date convertToDate(Date date) {
            return new java.sql.Date(date.getTime());
        }

        @Override
        public Object toJdbcType(Object value) {
            return BasicTypeConverter.toDate(value);
        }

        @Override
        public Date toBeanType(Object value) {
            return BasicTypeConverter.toUtilDate(value);
        }
    }

    public static class TimestampType
    extends ScalarTypeBaseDateTime<Date> {
        public TimestampType(JsonConfig.DateTime mode) {
            super(mode, Date.class, false, 93);
        }

        @Override
        protected String toJsonNanos(Date value) {
            return String.valueOf(value.getTime());
        }

        @Override
        protected String toJsonISO8601(Date value) {
            return IsoJsonDateTimeParser.formatIso(value.toInstant());
        }

        @Override
        public long convertToMillis(Date value) {
            return value.getTime();
        }

        @Override
        public Date read(DataReader reader) throws SQLException {
            Timestamp timestamp = reader.getTimestamp();
            if (timestamp == null) {
                return null;
            }
            return new Date(timestamp.getTime());
        }

        @Override
        public void bind(DataBinder binder, Date value) throws SQLException {
            if (value == null) {
                binder.setNull(93);
            } else {
                binder.setTimestamp(new Timestamp(value.getTime()));
            }
        }

        @Override
        public Object toJdbcType(Object value) {
            return BasicTypeConverter.toTimestamp(value);
        }

        @Override
        public Date toBeanType(Object value) {
            return BasicTypeConverter.toUtilDate(value);
        }

        @Override
        public Date convertFromTimestamp(Timestamp ts) {
            return new Date(ts.getTime());
        }

        @Override
        public Date convertFromInstant(Instant ts) {
            return new Date(ts.toEpochMilli());
        }

        @Override
        public Timestamp convertToTimestamp(Date date) {
            return new Timestamp(date.getTime());
        }

        @Override
        public Date convertFromMillis(long systemTimeMillis) {
            return new Date(systemTimeMillis);
        }
    }
}

