/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarTypeUUIDBase;
import java.sql.SQLException;
import java.util.UUID;

public class ScalarTypeUUIDBinary
extends ScalarTypeUUIDBase {
    private final boolean optimized;

    protected ScalarTypeUUIDBinary(boolean optimized) {
        super(false, -2);
        this.optimized = optimized;
    }

    @Override
    public int getLength() {
        return 16;
    }

    @Override
    public Object toJdbcType(Object value) {
        return ScalarTypeUUIDBinary.convertToBytes(value, this.optimized);
    }

    @Override
    public UUID toBeanType(Object value) {
        if (value instanceof byte[]) {
            return ScalarTypeUUIDBinary.convertFromBytes((byte[])value, this.optimized);
        }
        return BasicTypeConverter.toUUID(value, this.optimized);
    }

    @Override
    public void bind(DataBinder binder, UUID value) throws SQLException {
        if (value == null) {
            binder.setNull(-2);
        } else {
            binder.setBytes(ScalarTypeUUIDBinary.convertToBytes(value, this.optimized));
        }
    }

    @Override
    public UUID read(DataReader reader) throws SQLException {
        byte[] bytes = reader.getBytes();
        if (bytes == null) {
            return null;
        }
        return ScalarTypeUUIDBinary.convertFromBytes(bytes, this.optimized);
    }

    public static UUID convertFromBytes(byte[] bytes, boolean optimized) {
        int usableBytes = Math.min(bytes.length, 16);
        byte[] barr = new byte[16];
        int i = 15;
        for (int j = usableBytes - 1; j >= 0; --j) {
            barr[i] = bytes[j];
            --i;
        }
        long msb = optimized ? ((long)barr[4] << 56) + ((long)(barr[5] & 0xFF) << 48) + ((long)(barr[6] & 0xFF) << 40) + ((long)(barr[7] & 0xFF) << 32) + ((long)(barr[2] & 0xFF) << 24) + (long)((barr[3] & 0xFF) << 16) + (long)((barr[0] & 0xFF) << 8) + (long)((barr[1] & 0xFF) << 0) : ((long)barr[0] << 56) + ((long)(barr[1] & 0xFF) << 48) + ((long)(barr[2] & 0xFF) << 40) + ((long)(barr[3] & 0xFF) << 32) + ((long)(barr[4] & 0xFF) << 24) + (long)((barr[5] & 0xFF) << 16) + (long)((barr[6] & 0xFF) << 8) + (long)((barr[7] & 0xFF) << 0);
        long lsb = ((long)barr[8] << 56) + ((long)(barr[9] & 0xFF) << 48) + ((long)(barr[10] & 0xFF) << 40) + ((long)(barr[11] & 0xFF) << 32) + ((long)(barr[12] & 0xFF) << 24) + (long)((barr[13] & 0xFF) << 16) + (long)((barr[14] & 0xFF) << 8) + (long)((barr[15] & 0xFF) << 0);
        return new UUID(msb, lsb);
    }

    public static byte[] convertToBytes(Object value, boolean optimized) {
        UUID uuid = (UUID)value;
        byte[] ret = new byte[16];
        long l = uuid.getMostSignificantBits();
        if (optimized) {
            ret[0] = (byte)(l >>> 8);
            ret[1] = (byte)(l >>> 0);
            ret[2] = (byte)(l >>> 24);
            ret[3] = (byte)(l >>> 16);
            ret[4] = (byte)(l >>> 56);
            ret[5] = (byte)(l >>> 48);
            ret[6] = (byte)(l >>> 40);
            ret[7] = (byte)(l >>> 32);
        } else {
            ret[0] = (byte)(l >>> 56);
            ret[1] = (byte)(l >>> 48);
            ret[2] = (byte)(l >>> 40);
            ret[3] = (byte)(l >>> 32);
            ret[4] = (byte)(l >>> 24);
            ret[5] = (byte)(l >>> 16);
            ret[6] = (byte)(l >>> 8);
            ret[7] = (byte)(l >>> 0);
        }
        l = uuid.getLeastSignificantBits();
        ret[8] = (byte)(l >>> 56);
        ret[9] = (byte)(l >>> 48);
        ret[10] = (byte)(l >>> 40);
        ret[11] = (byte)(l >>> 32);
        ret[12] = (byte)(l >>> 24);
        ret[13] = (byte)(l >>> 16);
        ret[14] = (byte)(l >>> 8);
        ret[15] = (byte)(l >>> 0);
        return ret;
    }
}

