/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import io.ebean.text.TextException;
import io.ebean.text.json.EJson;
import io.ebeaninternal.server.type.PostgresHelper;
import io.ebeaninternal.server.type.ScalarTypeJsonCollection;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.PersistenceException;

final class ScalarTypeJsonSet {
    ScalarTypeJsonSet() {
    }

    static ScalarType<?> typeFor(boolean postgres, int dbType, DocPropertyType docPropertyType, boolean nullable, boolean keepSource) {
        if (postgres) {
            switch (dbType) {
                case 5002: {
                    return new JsonB(docPropertyType, nullable, keepSource);
                }
                case 5001: {
                    return new Json(docPropertyType, nullable, keepSource);
                }
            }
        }
        return new Varchar(docPropertyType, nullable, keepSource);
    }

    private static final class JsonB
    extends PgBase {
        private JsonB(DocPropertyType docPropertyType, boolean nullable, boolean keepSource) {
            super(5002, "jsonb", docPropertyType, nullable, keepSource);
        }
    }

    private static final class Json
    extends PgBase {
        private Json(DocPropertyType docPropertyType, boolean nullable, boolean keepSource) {
            super(5001, "json", docPropertyType, nullable, keepSource);
        }
    }

    static final class Varchar
    extends Base {
        public Varchar(DocPropertyType docPropertyType, boolean nullable, boolean keepSource) {
            super(12, docPropertyType, nullable, keepSource);
        }
    }

    private static class PgBase
    extends Base {
        final String pgType;

        PgBase(int jdbcType, String pgType, DocPropertyType docPropertyType, boolean nullable, boolean keepSource) {
            super(jdbcType, docPropertyType, nullable, keepSource);
            this.pgType = pgType;
        }

        @Override
        protected final void bindRawJson(DataBinder binder, String rawJson) throws SQLException {
            binder.setObject(PostgresHelper.asObject(this.pgType, rawJson));
        }

        @Override
        protected final void bindNull(DataBinder binder) throws SQLException {
            binder.setObject(PostgresHelper.asObject(this.pgType, this.nullable ? null : "[]"));
        }
    }

    private static abstract class Base
    extends ScalarTypeJsonCollection<Set> {
        final boolean keepSource;

        private Base(int dbType, DocPropertyType docPropertyType, boolean nullable, boolean keepSource) {
            super(Set.class, dbType, docPropertyType, nullable);
            this.keepSource = keepSource;
        }

        @Override
        public final boolean isJsonMapper() {
            return this.keepSource;
        }

        @Override
        public final Set read(DataReader reader) throws SQLException {
            String json = reader.getString();
            if (this.keepSource) {
                reader.pushJson(json);
            }
            try {
                return EJson.parseSet(json, true);
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as Set", json, e);
            }
        }

        @Override
        public final void bind(DataBinder binder, Set value) throws SQLException {
            String rawJson;
            String string = rawJson = this.keepSource ? binder.popJson() : null;
            if (rawJson == null && value != null) {
                rawJson = this.formatValue(value);
            }
            if (value == null) {
                this.bindNull(binder);
            } else {
                this.bindRawJson(binder, rawJson);
            }
        }

        @Override
        protected void bindNull(DataBinder binder) throws SQLException {
            if (this.nullable) {
                binder.setNull(12);
            } else {
                binder.setString("[]");
            }
        }

        protected void bindRawJson(DataBinder binder, String rawJson) throws SQLException {
            binder.setString(rawJson);
        }

        @Override
        public final String formatValue(Set value) {
            if (value.isEmpty()) {
                return "[]";
            }
            try {
                return EJson.write(value);
            }
            catch (IOException e) {
                throw new PersistenceException("Failed to format List into JSON content", e);
            }
        }

        @Override
        public final Set parse(String value) {
            try {
                return this.convertList(EJson.parseList(value));
            }
            catch (IOException e) {
                throw new PersistenceException("Failed to parse JSON content as Set: [" + value + "]", e);
            }
        }

        @Override
        public final Set jsonRead(JsonParser parser) throws IOException {
            return this.convertList(EJson.parseList(parser, parser.getCurrentToken()));
        }

        @Override
        public final void jsonWrite(JsonGenerator writer, Set value) throws IOException {
            EJson.write((Object)value, writer);
        }

        private Set convertList(List list) {
            return new LinkedHashSet(list);
        }
    }
}

