/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.text.TextException;
import io.ebeaninternal.server.type.ScalarHelp;
import io.ebeaninternal.server.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;

public abstract class ScalarTypeJsonNode
extends ScalarTypeBase<JsonNode> {
    final ObjectMapper objectMapper;

    public ScalarTypeJsonNode(ObjectMapper objectMapper, int jdbcType) {
        super(JsonNode.class, false, jdbcType);
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isDirty(Object value) {
        return true;
    }

    @Override
    public JsonNode read(DataReader reader) throws SQLException {
        String rawJson = reader.getString();
        if (rawJson == null) {
            return null;
        }
        return this.parse(rawJson);
    }

    @Override
    public void bind(DataBinder binder, JsonNode value) throws SQLException {
        if (value == null) {
            binder.setNull(12);
        } else {
            String rawJson = this.formatValue(value);
            binder.setString(rawJson);
        }
    }

    @Override
    public Object toJdbcType(Object value) {
        return value;
    }

    @Override
    public JsonNode toBeanType(Object value) {
        return (JsonNode)value;
    }

    @Override
    public String formatValue(JsonNode jsonNode) {
        try {
            return this.objectMapper.writeValueAsString(jsonNode);
        }
        catch (IOException e) {
            throw new TextException(e);
        }
    }

    @Override
    public JsonNode parse(String value) {
        try {
            return this.objectMapper.readValue(value, JsonNode.class);
        }
        catch (IOException e) {
            throw new TextException("Failed to parse JSON [{}] as JsonNode", value, e);
        }
    }

    public JsonNode parse(Reader reader) {
        try {
            return this.objectMapper.readValue(reader, JsonNode.class);
        }
        catch (IOException e) {
            throw new TextException(e);
        }
    }

    @Override
    public JsonNode convertFromMillis(long dateTime) {
        throw new RuntimeException("Should never be called");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public JsonNode readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return this.parse(dataInput.readUTF());
    }

    @Override
    public void writeData(DataOutput dataOutput, JsonNode value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            ScalarHelp.writeUTF(dataOutput, this.format(value));
        }
    }

    @Override
    public void jsonWrite(JsonGenerator writer, JsonNode value) throws IOException {
        this.objectMapper.writeTree(writer, value);
    }

    @Override
    public JsonNode jsonRead(JsonParser parser) throws IOException {
        return this.objectMapper.readValue(parser, JsonNode.class);
    }

    @Override
    public DocPropertyType getDocType() {
        return DocPropertyType.OBJECT;
    }

    public static class Blob
    extends ScalarTypeJsonNode {
        public Blob(ObjectMapper objectMapper) {
            super(objectMapper, 2004);
        }

        @Override
        public JsonNode read(DataReader dataReader) throws SQLException {
            JsonNode jsonNode;
            InputStream is = dataReader.getBinaryStream();
            if (is == null) {
                return null;
            }
            InputStreamReader reader = new InputStreamReader(is);
            try {
                jsonNode = this.parse(reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SQLException("Error reading Blob stream from DB", e);
                }
            }
            reader.close();
            return jsonNode;
        }

        @Override
        public void bind(DataBinder binder, JsonNode value) throws SQLException {
            if (value == null) {
                binder.setNull(2004);
            } else {
                String rawJson = this.formatValue(value);
                binder.setBlob(rawJson.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public static class Varchar
    extends ScalarTypeJsonNode {
        public Varchar(ObjectMapper objectMapper) {
            super(objectMapper, 12);
        }
    }

    public static class Clob
    extends ScalarTypeJsonNode {
        public Clob(ObjectMapper objectMapper) {
            super(objectMapper, 2005);
        }

        @Override
        public JsonNode read(DataReader reader) throws SQLException {
            String content = reader.getStringFromStream();
            if (content == null) {
                return null;
            }
            return this.parse(content);
        }
    }
}

