/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import io.ebean.text.TextException;
import io.ebean.text.json.EJson;
import io.ebeaninternal.server.type.PostgresHelper;
import io.ebeaninternal.server.type.ScalarTypeJsonCollection;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.PersistenceException;

class ScalarTypeJsonList {
    ScalarTypeJsonList() {
    }

    static ScalarType<?> typeFor(boolean postgres, int dbType, DocPropertyType docType, boolean nullable, boolean keepSource) {
        if (postgres) {
            switch (dbType) {
                case 5002: {
                    return new JsonB(docType, nullable, keepSource);
                }
                case 5001: {
                    return new Json(docType, nullable, keepSource);
                }
            }
        }
        return new Varchar(docType, nullable, keepSource);
    }

    private static final class JsonB
    extends PgBase {
        JsonB(DocPropertyType docType, boolean nullable, boolean keepSource) {
            super(5002, "jsonb", docType, nullable, keepSource);
        }
    }

    private static final class Json
    extends PgBase {
        Json(DocPropertyType docType, boolean nullable, boolean keepSource) {
            super(5001, "json", docType, nullable, keepSource);
        }
    }

    static final class Varchar
    extends Base {
        Varchar(DocPropertyType docType, boolean nullable, boolean keepSource) {
            super(12, docType, nullable, keepSource);
        }
    }

    private static class PgBase
    extends Base {
        final String pgType;

        PgBase(int jdbcType, String pgType, DocPropertyType docType, boolean nullable, boolean keepSource) {
            super(jdbcType, docType, nullable, keepSource);
            this.pgType = pgType;
        }

        @Override
        protected final void bindRawJson(DataBinder binder, String rawJson) throws SQLException {
            binder.setObject(PostgresHelper.asObject(this.pgType, rawJson));
        }

        @Override
        protected final void bindNull(DataBinder binder) throws SQLException {
            binder.setObject(PostgresHelper.asObject(this.pgType, this.nullable ? null : "[]"));
        }
    }

    private static abstract class Base
    extends ScalarTypeJsonCollection<List> {
        final boolean keepSource;

        private Base(int dbType, DocPropertyType docType, boolean nullable, boolean keepSource) {
            super(List.class, dbType, docType, nullable);
            this.keepSource = keepSource;
        }

        @Override
        public final boolean isJsonMapper() {
            return this.keepSource;
        }

        @Override
        public final List read(DataReader reader) throws SQLException {
            String json = reader.getString();
            if (this.keepSource) {
                reader.pushJson(json);
            }
            try {
                return EJson.parseList(json, true);
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as List", json, e);
            }
        }

        @Override
        public final void bind(DataBinder binder, List value) throws SQLException {
            String rawJson;
            String string = rawJson = this.keepSource ? binder.popJson() : null;
            if (rawJson == null && value != null) {
                rawJson = this.formatValue(value);
            }
            if (value == null) {
                this.bindNull(binder);
            } else {
                this.bindRawJson(binder, rawJson);
            }
        }

        @Override
        protected void bindNull(DataBinder binder) throws SQLException {
            if (this.nullable) {
                binder.setNull(12);
            } else {
                binder.setString("[]");
            }
        }

        protected void bindRawJson(DataBinder binder, String rawJson) throws SQLException {
            binder.setString(rawJson);
        }

        @Override
        public final String formatValue(List value) {
            if (value.isEmpty()) {
                return "[]";
            }
            try {
                return EJson.write(value);
            }
            catch (IOException e) {
                throw new PersistenceException("Failed to format List into JSON content", e);
            }
        }

        @Override
        public final List parse(String value) {
            try {
                return EJson.parseList(value, false);
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as List", value, e);
            }
        }

        @Override
        public final List jsonRead(JsonParser parser) throws IOException {
            return EJson.parseList(parser, parser.getCurrentToken());
        }

        @Override
        public final void jsonWrite(JsonGenerator writer, List value) throws IOException {
            EJson.write((Object)value, writer);
        }
    }
}

