/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.type.DataEncryptSupport;
import io.ebeaninternal.server.type.LocalEncryptedType;
import io.ebeaninternal.server.type.ScalarTypeBytesBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

public class ScalarTypeEncryptedWrapper<T>
implements ScalarType<T>,
LocalEncryptedType {
    private final ScalarType<T> wrapped;
    private final DataEncryptSupport dataEncryptSupport;
    private final ScalarTypeBytesBase byteArrayType;

    public ScalarTypeEncryptedWrapper(ScalarType<T> wrapped, ScalarTypeBytesBase byteArrayType, DataEncryptSupport dataEncryptSupport) {
        this.wrapped = wrapped;
        this.byteArrayType = byteArrayType;
        this.dataEncryptSupport = dataEncryptSupport;
    }

    @Override
    public Object localEncrypt(Object value) {
        String formatValue = this.wrapped.format(value);
        return this.dataEncryptSupport.encryptObject(formatValue);
    }

    @Override
    public long asVersion(T value) {
        throw new RuntimeException("not supported");
    }

    @Override
    public boolean isBinaryType() {
        return this.wrapped.isBinaryType();
    }

    @Override
    public boolean isMutable() {
        return this.wrapped.isMutable();
    }

    @Override
    public boolean isDirty(Object value) {
        return this.wrapped.isDirty(value);
    }

    @Override
    public T readData(DataInput dataInput) throws IOException {
        return this.wrapped.readData(dataInput);
    }

    @Override
    public void writeData(DataOutput dataOutput, T v) throws IOException {
        this.wrapped.writeData(dataOutput, v);
    }

    @Override
    public T read(DataReader reader) throws SQLException {
        byte[] data = reader.getBytes();
        String formattedValue = this.dataEncryptSupport.decryptObject(data);
        if (formattedValue == null) {
            return null;
        }
        return this.wrapped.parse(formattedValue);
    }

    private byte[] encrypt(T value) {
        if (value == null) {
            return null;
        }
        String formatValue = this.wrapped.formatValue(value);
        return this.dataEncryptSupport.encryptObject(formatValue);
    }

    @Override
    public void bind(DataBinder binder, T value) throws SQLException {
        byte[] encryptedValue = this.encrypt(value);
        this.byteArrayType.bind(binder, encryptedValue);
    }

    @Override
    public int getJdbcType() {
        return this.byteArrayType.getJdbcType();
    }

    @Override
    public int getLength() {
        return this.byteArrayType.getLength();
    }

    @Override
    public Class<T> getType() {
        return this.wrapped.getType();
    }

    @Override
    public boolean isDateTimeCapable() {
        return this.wrapped.isDateTimeCapable();
    }

    @Override
    public boolean isJdbcNative() {
        return false;
    }

    @Override
    public void loadIgnore(DataReader dataReader) {
        this.wrapped.loadIgnore(dataReader);
    }

    @Override
    public String format(Object v) {
        return this.formatValue(v);
    }

    @Override
    public String formatValue(T v) {
        return this.wrapped.formatValue(v);
    }

    @Override
    public T parse(String value) {
        return this.wrapped.parse(value);
    }

    @Override
    public T convertFromMillis(long systemTimeMillis) {
        return this.wrapped.convertFromMillis(systemTimeMillis);
    }

    @Override
    public T toBeanType(Object value) {
        return this.wrapped.toBeanType(value);
    }

    @Override
    public Object toJdbcType(Object value) {
        return this.wrapped.toJdbcType(value);
    }

    @Override
    public T jsonRead(JsonParser parser) throws IOException {
        return this.wrapped.jsonRead(parser);
    }

    @Override
    public void jsonWrite(JsonGenerator writer, T value) throws IOException {
        this.wrapped.jsonWrite(writer, value);
    }

    @Override
    public DocPropertyType getDocType() {
        return this.wrapped.getDocType();
    }
}

