/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarTypeBaseVarchar;
import java.io.IOException;
import java.sql.SQLException;

public class ScalarTypeCharArray
extends ScalarTypeBaseVarchar<char[]> {
    public ScalarTypeCharArray() {
        super(char[].class, false, 12);
    }

    @Override
    public char[] convertFromDbString(String dbValue) {
        return dbValue.toCharArray();
    }

    @Override
    public String convertToDbString(char[] beanValue) {
        return new String(beanValue);
    }

    @Override
    public void bind(DataBinder binder, char[] value) throws SQLException {
        if (value == null) {
            binder.setNull(12);
        } else {
            String s2 = BasicTypeConverter.toString(value);
            binder.setString(s2);
        }
    }

    @Override
    public char[] read(DataReader reader) throws SQLException {
        String string = reader.getString();
        if (string == null) {
            return null;
        }
        return string.toCharArray();
    }

    @Override
    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toString(value);
    }

    @Override
    public char[] toBeanType(Object value) {
        if (value == null) {
            return null;
        }
        String s2 = BasicTypeConverter.toString(value);
        return s2.toCharArray();
    }

    @Override
    public String formatValue(char[] t) {
        return String.valueOf(t);
    }

    @Override
    public char[] parse(String value) {
        return value.toCharArray();
    }

    @Override
    public char[] jsonRead(JsonParser parser) throws IOException {
        return parser.getValueAsString().toCharArray();
    }

    public void jsonWrite(JsonGenerator ctx, String name, char[] value) throws IOException {
        ctx.writeStringField(name, String.valueOf(value));
    }
}

