/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataReader;
import io.ebeaninternal.server.core.timezone.DataTimeZone;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class RsetDataReader
implements DataReader {
    private static final int bufferSize = 512;
    static final int clobBufferSize = 512;
    static final int stringInitialSize = 512;
    private final DataTimeZone dataTimeZone;
    private final ResultSet rset;
    protected int pos;
    private String json;

    public RsetDataReader(DataTimeZone dataTimeZone, ResultSet rset) {
        this.dataTimeZone = dataTimeZone;
        this.rset = rset;
    }

    @Override
    public void pushJson(String json) {
        this.json = json;
    }

    @Override
    public String popJson() {
        return this.json;
    }

    @Override
    public void close() throws SQLException {
        this.rset.close();
    }

    @Override
    public boolean next() throws SQLException {
        this.pos = 0;
        return this.rset.next();
    }

    @Override
    public void incrementPos(int increment) {
        this.pos += increment;
    }

    protected int pos() {
        return ++this.pos;
    }

    @Override
    public Array getArray() throws SQLException {
        return this.rset.getArray(this.pos());
    }

    @Override
    public Object getObject() throws SQLException {
        return this.rset.getObject(this.pos());
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        return this.rset.getBigDecimal(this.pos());
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return this.rset.getBinaryStream(this.pos());
    }

    @Override
    public Boolean getBoolean() throws SQLException {
        boolean v = this.rset.getBoolean(this.pos());
        return this.rset.wasNull() ? null : Boolean.valueOf(v);
    }

    @Override
    public Byte getByte() throws SQLException {
        byte v = this.rset.getByte(this.pos());
        return this.rset.wasNull() ? null : Byte.valueOf(v);
    }

    @Override
    public byte[] getBytes() throws SQLException {
        return this.rset.getBytes(this.pos());
    }

    @Override
    public Date getDate() throws SQLException {
        Calendar cal = this.dataTimeZone.getDateTimeZone();
        if (cal != null) {
            return this.rset.getDate(this.pos(), cal);
        }
        return this.rset.getDate(this.pos());
    }

    @Override
    public Double getDouble() throws SQLException {
        double v = this.rset.getDouble(this.pos());
        return this.rset.wasNull() ? null : Double.valueOf(v);
    }

    @Override
    public Float getFloat() throws SQLException {
        float v = this.rset.getFloat(this.pos());
        return this.rset.wasNull() ? null : Float.valueOf(v);
    }

    @Override
    public Integer getInt() throws SQLException {
        int v = this.rset.getInt(this.pos());
        return this.rset.wasNull() ? null : Integer.valueOf(v);
    }

    @Override
    public Long getLong() throws SQLException {
        long v = this.rset.getLong(this.pos());
        return this.rset.wasNull() ? null : Long.valueOf(v);
    }

    public Ref getRef() throws SQLException {
        return this.rset.getRef(this.pos());
    }

    @Override
    public Short getShort() throws SQLException {
        short s2 = this.rset.getShort(this.pos());
        return this.rset.wasNull() ? null : Short.valueOf(s2);
    }

    @Override
    public String getString() throws SQLException {
        return this.rset.getString(this.pos());
    }

    @Override
    public Time getTime() throws SQLException {
        Calendar cal = this.dataTimeZone.getTimeZone();
        if (cal != null) {
            return this.rset.getTime(this.pos(), cal);
        }
        return this.rset.getTime(this.pos());
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        Calendar cal = this.dataTimeZone.getTimeZone();
        if (cal != null) {
            return this.rset.getTimestamp(this.pos(), cal);
        }
        return this.rset.getTimestamp(this.pos());
    }

    @Override
    public String getStringFromStream() throws SQLException {
        Reader reader = this.rset.getCharacterStream(this.pos());
        return reader == null ? null : this.readStringLob(reader);
    }

    protected String readStringLob(Reader reader) throws SQLException {
        char[] buffer = new char[512];
        StringBuilder out = new StringBuilder(512);
        try {
            int readLength;
            while ((readLength = reader.read(buffer)) != -1) {
                out.append(buffer, 0, readLength);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new SQLException("IOException reading Clob " + e.getMessage());
        }
        return out.toString();
    }

    @Override
    public byte[] getBinaryBytes() throws SQLException {
        InputStream in = this.rset.getBinaryStream(this.pos());
        return this.getBinaryLob(in);
    }

    protected byte[] getBinaryLob(InputStream in) throws SQLException {
        byte[] byArray;
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buf = new byte[512];
            while ((len = in.read(buf, 0, buf.length)) != -1) {
                out.write(buf, 0, len);
            }
            byte[] data = out.toByteArray();
            if (data.length == 0) {
                data = null;
            }
            in.close();
            byArray = data;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SQLException(e.getClass().getName() + ":" + e.getMessage());
            }
        }
        out.close();
        return byArray;
    }
}

