/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebeaninternal.server.type.EnumToDbValueMap;
import java.sql.SQLException;
import javax.persistence.PersistenceException;

public class EnumToDbIntegerMap
extends EnumToDbValueMap<Integer> {
    @Override
    public int getDbType() {
        return 4;
    }

    public EnumToDbIntegerMap() {
        this(true);
    }

    public EnumToDbIntegerMap(boolean allowNulls) {
        super(allowNulls, true);
    }

    public void add(Object beanValue, Integer dbValue, String name) {
        this.addInternal(beanValue, dbValue, name);
    }

    public EnumToDbIntegerMap add(Object beanValue, String stringDbValue, String name) {
        try {
            Integer value = Integer.valueOf(stringDbValue);
            this.addInternal(beanValue, value, name);
            return this;
        }
        catch (Exception e) {
            String msg = "Error converted enum type[" + beanValue.getClass().getName();
            msg = msg + "] enum value[" + beanValue + "] string value [" + stringDbValue + "]";
            msg = msg + " to an Integer.";
            throw new PersistenceException(msg, e);
        }
    }

    @Override
    public void bind(DataBinder binder, Object value) throws SQLException {
        if (value == null) {
            binder.setNull(4);
        } else {
            Integer s2 = (Integer)this.getDbValue(value);
            binder.setInt(s2);
        }
    }

    @Override
    public Object read(DataReader reader) throws SQLException {
        Integer i = reader.getInt();
        if (i == null) {
            return null;
        }
        return this.getBeanValue(i);
    }
}

