/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.config.CurrentTenantProvider;
import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.transaction.DataSourceSupplier;
import io.ebeaninternal.server.transaction.ImplicitReadOnlyTransaction;
import io.ebeaninternal.server.transaction.TransactionFactoryTenant;
import io.ebeaninternal.server.transaction.TransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.PersistenceException;

final class TransactionFactoryTenantWithRead
extends TransactionFactoryTenant {
    TransactionFactoryTenantWithRead(TransactionManager manager, DataSourceSupplier dataSourceSupplier, CurrentTenantProvider tenantProvider) {
        super(manager, dataSourceSupplier, tenantProvider);
    }

    @Override
    public SpiTransaction createReadOnlyTransaction(Object tenantId) {
        Connection connection = null;
        try {
            if (tenantId == null) {
                tenantId = this.tenantProvider.currentId();
            }
            connection = this.dataSourceSupplier.getReadOnlyConnection(tenantId);
            return new ImplicitReadOnlyTransaction(this.manager, connection, tenantId);
        }
        catch (PersistenceException ex) {
            JdbcClose.close(connection);
            throw ex;
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex);
        }
    }
}

