/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.transaction.DataSourceSupplier;
import io.ebeaninternal.server.transaction.TransactionFactory;
import io.ebeaninternal.server.transaction.TransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;

class TransactionFactoryBasic
extends TransactionFactory {
    private final DataSource dataSource;

    TransactionFactoryBasic(TransactionManager manager, DataSourceSupplier dataSourceSupplier) {
        super(manager);
        this.dataSource = dataSourceSupplier.getDataSource();
    }

    @Override
    public SpiTransaction createReadOnlyTransaction(Object tenantId) {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            return this.create(false, connection);
        }
        catch (PersistenceException ex) {
            JdbcClose.close(connection);
            throw ex;
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex);
        }
    }

    @Override
    public final SpiTransaction createTransaction(boolean explicit, int isolationLevel) {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            SpiTransaction t = this.create(explicit, connection);
            return this.setIsolationLevel(t, explicit, isolationLevel);
        }
        catch (PersistenceException ex) {
            JdbcClose.close(connection);
            throw ex;
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex);
        }
    }

    private SpiTransaction create(boolean explicit, Connection c) {
        return this.manager.createTransaction(explicit, c);
    }
}

