/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.ProfileLocation;
import io.ebean.TransactionCallback;
import io.ebean.annotation.DocStoreMode;
import io.ebean.event.changelog.BeanChange;
import io.ebean.event.changelog.ChangeSet;
import io.ebeaninternal.api.SpiPersistenceContext;
import io.ebeaninternal.api.SpiProfileTransactionEvent;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.TransactionEvent;
import io.ebeaninternal.api.TxnProfileEventCodes;
import io.ebeaninternal.server.core.PersistDeferredRelationship;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.persist.BatchControl;
import io.ebeaninternal.server.transaction.DefaultPersistenceContext;
import io.ebeaninternal.server.transaction.ProfileStream;
import io.ebeaninternal.server.transaction.TransactionManager;
import io.ebeanservice.docstore.api.DocStoreTransaction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ImplicitReadOnlyTransaction
implements SpiTransaction,
TxnProfileEventCodes {
    private static final Logger logger = LoggerFactory.getLogger(ImplicitReadOnlyTransaction.class);
    private static final String illegalStateMessage = "Transaction is Inactive";
    private static final String notExpectedMessage = "Not expected on read only transaction";
    private final TransactionManager manager;
    private final boolean logSql;
    private final boolean logSummary;
    private boolean active;
    private Connection connection;
    private SpiPersistenceContext persistenceContext;
    private Object tenantId;
    private Map<String, Object> userObjects;
    private final long startNanos;
    private ProfileLocation profileLocation;

    ImplicitReadOnlyTransaction(TransactionManager manager, Connection connection) {
        this.manager = manager;
        this.logSql = manager.isLogSql();
        this.logSummary = manager.isLogSummary();
        this.active = true;
        this.connection = connection;
        this.persistenceContext = new DefaultPersistenceContext();
        this.startNanos = System.nanoTime();
    }

    ImplicitReadOnlyTransaction(TransactionManager manager, Connection connection, Object tenantId) {
        this(manager, connection);
        this.tenantId = tenantId;
    }

    @Override
    public long getStartNanoTime() {
        return this.startNanos;
    }

    @Override
    public void setAutoPersistUpdates(boolean autoPersistUpdates) {
    }

    @Override
    public boolean isAutoPersistUpdates() {
        return false;
    }

    @Override
    public void setLabel(String label) {
    }

    @Override
    public String getLabel() {
        return null;
    }

    @Override
    public long profileOffset() {
        return 0L;
    }

    @Override
    public void profileEvent(SpiProfileTransactionEvent event) {
    }

    @Override
    public void setProfileStream(ProfileStream profileStream) {
    }

    @Override
    public ProfileStream profileStream() {
        return null;
    }

    @Override
    public void setProfileLocation(ProfileLocation profileLocation) {
        this.profileLocation = profileLocation;
    }

    @Override
    public ProfileLocation getProfileLocation() {
        return this.profileLocation;
    }

    @Override
    public boolean isSkipCache() {
        return false;
    }

    @Override
    public boolean isSkipCacheExplicit() {
        return false;
    }

    @Override
    public void setSkipCache(boolean skipCache) {
    }

    @Override
    public String getLogPrefix() {
        return null;
    }

    @Override
    public void addBeanChange(BeanChange beanChange) {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public void sendChangeLog(ChangeSet changesRequest) {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public void register(TransactionCallback callback) {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public int getDocStoreBatchSize() {
        return 0;
    }

    @Override
    public void setDocStoreBatchSize(int docStoreBatchSize) {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public DocStoreMode getDocStoreMode() {
        return null;
    }

    @Override
    public void setDocStoreMode(DocStoreMode docStoreMode) {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public void registerDeferred(PersistDeferredRelationship derived) {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public void registerDeleteBean(Integer persistingBean) {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public boolean isRegisteredDeleteBean(Integer persistingBean) {
        return false;
    }

    @Override
    public void unregisterBeans() {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public boolean isRegisteredBean(Object bean) {
        return false;
    }

    @Override
    public boolean isSaveAssocManyIntersection(String intersectionTable, String beanName) {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public void depth(int diff) {
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void markNotQueryOnly() {
    }

    @Override
    public boolean isNestedUseSavepoint() {
        return false;
    }

    @Override
    public void setNestedUseSavepoint() {
    }

    @Override
    public boolean isReadOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void setUpdateAllLoadedProperties(boolean updateAllLoadedProperties) {
    }

    @Override
    public Boolean isUpdateAllLoadedProperties() {
        return null;
    }

    @Override
    public void setBatchMode(boolean batchMode) {
    }

    @Override
    public boolean isBatchMode() {
        return false;
    }

    @Override
    public boolean isBatchOnCascade() {
        return false;
    }

    @Override
    public void setBatchOnCascade(boolean batchMode) {
    }

    @Override
    public Boolean getBatchGetGeneratedKeys() {
        return null;
    }

    @Override
    public void setGetGeneratedKeys(boolean getGeneratedKeys) {
    }

    @Override
    public void setFlushOnMixed(boolean batchFlushOnMixed) {
    }

    @Override
    public int getBatchSize() {
        return 0;
    }

    @Override
    public void setBatchSize(int batchSize) {
    }

    @Override
    public boolean isFlushOnQuery() {
        return false;
    }

    @Override
    public void setFlushOnQuery(boolean batchFlushOnQuery) {
    }

    @Override
    public boolean isBatchThisRequest() {
        return false;
    }

    @Override
    public void checkBatchEscalationOnCollection() {
    }

    @Override
    public void flushBatchOnCollection() {
    }

    @Override
    public PersistenceException translate(String message, SQLException cause) {
        return new PersistenceException(message, cause);
    }

    @Override
    public void flushBatchOnCascade() {
    }

    @Override
    public void flushBatchOnRollback() {
    }

    @Override
    public boolean checkBatchEscalationOnCascade(PersistRequestBean<?> request) {
        return false;
    }

    @Override
    public BatchControl getBatchControl() {
        return null;
    }

    @Override
    public void setBatchControl(BatchControl batchControl) {
    }

    @Override
    public void flush() {
    }

    @Override
    public void flushBatch() {
        this.flush();
    }

    @Override
    public SpiPersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public void setPersistenceContext(SpiPersistenceContext context) {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.persistenceContext = context;
    }

    @Override
    public TransactionEvent getEvent() {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public boolean isExplicit() {
        return false;
    }

    @Override
    public boolean isLogSql() {
        return this.logSql;
    }

    @Override
    public boolean isLogSummary() {
        return this.logSummary;
    }

    @Override
    public void logSql(String msg) {
        this.manager.log().sql().debug(msg);
    }

    @Override
    public void logSummary(String msg) {
        this.manager.log().sum().debug(msg);
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public void setTenantId(Object tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Object getTenantId() {
        return this.tenantId;
    }

    @Override
    public Connection getInternalConnection() {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        return this.connection;
    }

    @Override
    public Connection getConnection() {
        return this.getInternalConnection();
    }

    private void deactivate() {
        try {
            this.connection.close();
        }
        catch (Exception ex) {
            logger.error("Error closing connection", ex);
        }
        this.connection = null;
        this.active = false;
        this.manager.collectMetricReadOnly((System.nanoTime() - this.startNanos) / 1000L);
    }

    @Override
    public void commitAndContinue() {
    }

    @Override
    public void commit() {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.deactivate();
    }

    @Override
    public boolean isRollbackOnly() {
        return false;
    }

    @Override
    public void setRollbackOnly() {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public void rollback() throws PersistenceException {
        this.rollback(null);
    }

    @Override
    public void rollback(Throwable cause) throws PersistenceException {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.deactivate();
    }

    @Override
    public void end() throws PersistenceException {
        if (this.isActive()) {
            this.rollback();
        }
    }

    @Override
    public void preCommit() {
    }

    @Override
    public void postCommit() {
    }

    @Override
    public void postRollback(Throwable cause) {
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isPersistCascade() {
        return false;
    }

    @Override
    public void setPersistCascade(boolean persistCascade) {
    }

    @Override
    public void addModification(String tableName, boolean inserts, boolean updates, boolean deletes) {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public DocStoreTransaction getDocStoreTransaction() {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public void putUserObject(String name, Object value) {
        if (this.userObjects == null) {
            this.userObjects = new HashMap<String, Object>();
        }
        this.userObjects.put(name, value);
    }

    @Override
    public Object getUserObject(String name) {
        if (this.userObjects == null) {
            return null;
        }
        return this.userObjects.get(name);
    }

    @Override
    public void close() {
        this.end();
    }
}

