/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.util.SplitName;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.query.STreeType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

final class SqlTreeAlias {
    private final SpiQuery.TemporalMode temporalMode;
    private int counter;
    private int manyWhereCounter;
    private final TreeSet<String> joinProps = new TreeSet();
    private HashSet<String> embeddedPropertyJoins;
    private final TreeSet<String> manyWhereJoinProps = new TreeSet();
    private final HashMap<String, String> aliasMap = new HashMap();
    private final HashMap<String, String> manyWhereAliasMap = new HashMap();
    private final String rootTableAlias;

    SqlTreeAlias(String rootTableAlias, SpiQuery.TemporalMode temporalMode) {
        this.rootTableAlias = rootTableAlias;
        this.temporalMode = temporalMode;
    }

    void addManyWhereJoins(Set<String> manyWhereJoins) {
        if (manyWhereJoins != null) {
            for (String include : manyWhereJoins) {
                this.addPropertyJoin(include, this.manyWhereJoinProps);
            }
        }
    }

    private void addEmbeddedPropertyJoin(String embProp) {
        if (this.embeddedPropertyJoins == null) {
            this.embeddedPropertyJoins = new HashSet();
        }
        this.embeddedPropertyJoins.add(embProp);
    }

    public void addJoin(Set<String> propJoins, STreeType desc) {
        if (propJoins != null) {
            for (String propJoin : propJoins) {
                if (desc.isEmbeddedPath(propJoin)) {
                    this.addEmbeddedPropertyJoin(propJoin);
                    continue;
                }
                this.addPropertyJoin(propJoin, this.joinProps);
            }
        }
    }

    private void addPropertyJoin(String include, TreeSet<String> set) {
        String[] split;
        if (set.add(include) && (split = SplitName.split(include))[0] != null) {
            this.addPropertyJoin(split[0], set);
        }
    }

    void buildAlias() {
        for (String joinProp : this.joinProps) {
            this.calcAlias(joinProp);
        }
        for (String joinProp : this.manyWhereJoinProps) {
            this.calcAliasManyWhere(joinProp);
        }
        this.mapEmbeddedPropertyAlias();
    }

    private void mapEmbeddedPropertyAlias() {
        if (this.embeddedPropertyJoins != null) {
            for (String propJoin : this.embeddedPropertyJoins) {
                String[] split = SplitName.split(propJoin);
                String alias = this.getTableAlias(split[0]);
                this.aliasMap.put(propJoin, alias);
            }
        }
    }

    private String calcAlias(String prefix) {
        String alias = this.nextTableAlias();
        this.aliasMap.put(prefix, alias);
        return alias;
    }

    private void calcAliasManyWhere(String prefix) {
        String alias = this.nextManyWhereTableAlias();
        this.manyWhereAliasMap.put(prefix, alias);
    }

    String getTableAlias(String prefix) {
        if (prefix == null) {
            return this.rootTableAlias;
        }
        String s2 = this.aliasMap.get(prefix);
        if (s2 == null) {
            return this.calcAlias(prefix);
        }
        return s2;
    }

    String getTableAliasManyWhere(String prefix) {
        if (prefix == null) {
            return this.rootTableAlias;
        }
        String s2 = this.manyWhereAliasMap.get(prefix);
        if (s2 == null) {
            s2 = this.aliasMap.get(prefix);
        }
        if (s2 == null) {
            String msg = "Could not determine table alias for [" + prefix + "] manyMap[" + this.manyWhereAliasMap + "] aliasMap[" + this.aliasMap + "]";
            throw new RuntimeException(msg);
        }
        return s2;
    }

    String parseWhere(String clause) {
        clause = this.parseRootAlias(clause);
        clause = this.parseAliasMap(clause, this.manyWhereAliasMap);
        return this.parseAliasMap(clause, this.aliasMap);
    }

    public String parse(String clause) {
        clause = this.parseRootAlias(clause);
        return this.parseAliasMap(clause, this.aliasMap);
    }

    String parseRootAlias(String clause) {
        if (this.rootTableAlias == null) {
            return clause.replace("${}", "");
        }
        return clause.replace("${}", this.rootTableAlias + ".");
    }

    private String parseAliasMap(String clause, HashMap<String, String> parseAliasMap) {
        for (Map.Entry<String, String> e : parseAliasMap.entrySet()) {
            String k = "${" + e.getKey() + "}";
            clause = clause.replace(k, e.getValue() + ".");
        }
        return clause;
    }

    private String nextTableAlias() {
        return "t" + ++this.counter;
    }

    private String nextManyWhereTableAlias() {
        return "u" + ++this.manyWhereCounter;
    }

    boolean isIncludeJoins() {
        return !this.aliasMap.isEmpty() || !this.manyWhereAliasMap.isEmpty();
    }

    boolean isIncludeSoftDelete() {
        return this.temporalMode == SpiQuery.TemporalMode.SOFT_DELETED;
    }
}

