/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.QueryIterator;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.DtoQueryRequest;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.query.DtoQueryIterator;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.persistence.PersistenceException;

public final class DtoQueryEngine {
    private final Binder binder;

    public DtoQueryEngine(Binder binder) {
        this.binder = binder;
    }

    public <T> List<T> findList(DtoQueryRequest<T> request) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.LIST);
            ArrayList<T> rows = new ArrayList<T>();
            while (request.next()) {
                rows.add(request.readNextBean());
            }
            ArrayList<T> arrayList = rows;
            return arrayList;
        }
        catch (SQLException e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), e);
        }
        finally {
            request.close();
        }
    }

    public <T> QueryIterator<T> findIterate(DtoQueryRequest<T> request) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.ITERATE);
            return new DtoQueryIterator<T>(request);
        }
        catch (SQLException e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), e);
        }
    }

    public <T> void findEach(DtoQueryRequest<T> request, Consumer<T> consumer) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.ITERATE);
            while (request.next()) {
                consumer.accept(request.readNextBean());
            }
        }
        catch (SQLException e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), e);
        }
        finally {
            request.close();
        }
    }

    public <T> void findEach(DtoQueryRequest<T> request, int batchSize, Consumer<List<T>> consumer) {
        try {
            ArrayList<T> buffer = new ArrayList<T>();
            request.executeSql(this.binder, SpiQuery.Type.ITERATE);
            while (request.next()) {
                buffer.add(request.readNextBean());
                if (buffer.size() < batchSize) continue;
                consumer.accept(buffer);
                buffer.clear();
            }
            if (!buffer.isEmpty()) {
                consumer.accept(buffer);
            }
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), e);
        }
        finally {
            request.close();
        }
    }

    public <T> void findEachWhile(DtoQueryRequest<T> request, Predicate<T> consumer) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.ITERATE);
            while (request.next() && consumer.test(request.readNextBean())) {
            }
        }
        catch (SQLException e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), e);
        }
        finally {
            request.close();
        }
    }

    private String errMsg(String msg, String sql) {
        return "Query threw SQLException:" + msg + " Query was:" + sql;
    }
}

