/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.SqlRow;
import io.ebeaninternal.server.core.BasicTypeConverter;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class DefaultSqlRow
implements SqlRow {
    private static final long serialVersionUID = -3120927797041336242L;
    private final String dbTrueValue;
    private final boolean optimizedBinaryUUID;
    private final Map<String, Object> map;

    public DefaultSqlRow(int initialCapacity, float loadFactor, String dbTrueValue, boolean optimizedBinaryUUID) {
        this.map = new LinkedHashMap<String, Object>(initialCapacity, loadFactor);
        this.dbTrueValue = dbTrueValue;
        this.optimizedBinaryUUID = optimizedBinaryUUID;
    }

    @Override
    public Iterator<String> keys() {
        return this.map.keySet().iterator();
    }

    private Object asKey(Object name) {
        return ((String)name).toLowerCase();
    }

    @Override
    public Object remove(Object name) {
        return this.map.remove(this.asKey(name));
    }

    @Override
    public Object get(Object name) {
        return this.map.get(this.asKey(name));
    }

    @Override
    public Object put(String name, Object value) {
        return this.setInternal(name, value);
    }

    @Override
    public Object set(String name, Object value) {
        return this.setInternal(name, value);
    }

    private Object setInternal(String name, Object newValue) {
        return this.map.put(name.toLowerCase(), newValue);
    }

    @Override
    public UUID getUUID(String name) {
        return BasicTypeConverter.toUUID(this.get(name), this.optimizedBinaryUUID);
    }

    @Override
    public Boolean getBoolean(String name) {
        return BasicTypeConverter.toBoolean(this.get(name), this.dbTrueValue);
    }

    @Override
    public Integer getInteger(String name) {
        return BasicTypeConverter.toInteger(this.get(name));
    }

    @Override
    public BigDecimal getBigDecimal(String name) {
        return BasicTypeConverter.toBigDecimal(this.get(name));
    }

    @Override
    public Long getLong(String name) {
        return BasicTypeConverter.toLong(this.get(name));
    }

    @Override
    public Double getDouble(String name) {
        return BasicTypeConverter.toDouble(this.get(name));
    }

    @Override
    public Float getFloat(String name) {
        return BasicTypeConverter.toFloat(this.get(name));
    }

    @Override
    public String getString(String name) {
        return BasicTypeConverter.toString(this.get(name));
    }

    @Override
    public Date getUtilDate(String name) {
        return BasicTypeConverter.toUtilDate(this.get(name));
    }

    @Override
    public java.sql.Date getDate(String name) {
        return BasicTypeConverter.toDate(this.get(name));
    }

    @Override
    public Timestamp getTimestamp(String name) {
        return BasicTypeConverter.toTimestamp(this.get(name));
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(this.asKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public void putAll(Map<? extends String, ?> t) {
        this.map.putAll(t);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }
}

