/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.RowConsumer;
import io.ebean.RowMapper;
import io.ebean.SqlRow;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.ScalarType;
import io.ebean.meta.MetricVisitor;
import io.ebean.metric.MetricFactory;
import io.ebean.metric.TimedMetricMap;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.RelationalQueryEngine;
import io.ebeaninternal.server.core.RelationalQueryRequest;
import io.ebeaninternal.server.core.RowReader;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.query.DefaultSqlRow;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.persistence.PersistenceException;

public final class DefaultRelationalQueryEngine
implements RelationalQueryEngine {
    private final Binder binder;
    private final String dbTrueValue;
    private final boolean binaryOptimizedUUID;
    private final TimedMetricMap timedMetricMap;

    public DefaultRelationalQueryEngine(Binder binder, String dbTrueValue, boolean binaryOptimizedUUID) {
        this.binder = binder;
        this.dbTrueValue = dbTrueValue == null ? "true" : dbTrueValue;
        this.binaryOptimizedUUID = binaryOptimizedUUID;
        this.timedMetricMap = MetricFactory.get().createTimedMetricMap("sql.query.");
    }

    @Override
    public void collect(String label, long exeMicros) {
        this.timedMetricMap.add(label, exeMicros);
    }

    @Override
    public void visitMetrics(MetricVisitor visitor) {
        this.timedMetricMap.visit(visitor);
    }

    @Override
    public SqlRow createSqlRow(int estimateCapacity) {
        return new DefaultSqlRow(estimateCapacity, 0.75f, this.dbTrueValue, this.binaryOptimizedUUID);
    }

    private String errMsg(String msg, String sql) {
        return "Query threw SQLException:" + msg + " Query was:" + sql;
    }

    @Override
    public void findEach(RelationalQueryRequest request, RowConsumer consumer) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.ITERATE);
            request.mapEach(consumer);
            request.logSummary();
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), e);
        }
        finally {
            request.close();
        }
    }

    @Override
    public <T> void findEach(RelationalQueryRequest request, RowReader<T> reader, Predicate<T> consumer) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.ITERATE);
            while (request.next() && consumer.test(reader.read())) {
            }
            request.logSummary();
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), e);
        }
        finally {
            request.close();
        }
    }

    @Override
    public <T> T findOne(RelationalQueryRequest request, RowMapper<T> mapper) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.BEAN);
            T value = request.mapOne(mapper);
            request.logSummary();
            T t = value;
            return t;
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), e);
        }
        finally {
            request.close();
        }
    }

    @Override
    public <T> List<T> findList(RelationalQueryRequest request, RowReader<T> reader) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.LIST);
            ArrayList<T> rows = new ArrayList<T>();
            while (request.next()) {
                rows.add(reader.read());
            }
            request.logSummary();
            ArrayList<T> arrayList = rows;
            return arrayList;
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), e);
        }
        finally {
            request.close();
        }
    }

    @Override
    public <T> T findSingleAttribute(RelationalQueryRequest request, Class<T> cls) {
        ScalarType<?> scalarType = this.binder.getScalarType(cls);
        try {
            request.executeSql(this.binder, SpiQuery.Type.ATTRIBUTE);
            DataReader dataReader = this.binder.createDataReader(request.getResultSet());
            T value = null;
            if (dataReader.next()) {
                value = (T)scalarType.read(dataReader);
            }
            request.logSummary();
            T t = value;
            return t;
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), e);
        }
        finally {
            request.close();
        }
    }

    @Override
    public <T> List<T> findSingleAttributeList(RelationalQueryRequest request, Class<T> cls) {
        ScalarType<?> scalarType = this.binder.getScalarType(cls);
        try {
            request.executeSql(this.binder, SpiQuery.Type.ATTRIBUTE);
            DataReader dataReader = this.binder.createDataReader(request.getResultSet());
            ArrayList rows = new ArrayList();
            while (dataReader.next()) {
                rows.add(scalarType.read(dataReader));
            }
            request.logSummary();
            ArrayList arrayList = rows;
            return arrayList;
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), e);
        }
        finally {
            request.close();
        }
    }

    @Override
    public <T> void findSingleAttributeEach(RelationalQueryRequest request, Class<T> cls, Consumer<T> consumer) {
        ScalarType<?> scalarType = this.binder.getScalarType(cls);
        try {
            request.executeSql(this.binder, SpiQuery.Type.ATTRIBUTE);
            DataReader dataReader = this.binder.createDataReader(request.getResultSet());
            while (dataReader.next()) {
                consumer.accept(scalarType.read(dataReader));
            }
            request.logSummary();
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), e);
        }
        finally {
            request.close();
        }
    }
}

