/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.QueryIterator;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.query.CQuery;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.NoSuchElementException;

final class CQueryIteratorWithBuffer<T>
implements QueryIterator<T> {
    private final CQuery<T> cquery;
    private final int bufferSize;
    private final OrmQueryRequest<T> request;
    private final ArrayList<T> buffer;
    private boolean closed;
    private boolean moreToLoad = true;

    CQueryIteratorWithBuffer(CQuery<T> cquery, OrmQueryRequest<T> request, int bufferSize) {
        this.cquery = cquery;
        this.request = request;
        this.bufferSize = bufferSize;
        this.buffer = new ArrayList(bufferSize);
    }

    @Override
    public boolean hasNext() {
        int ret = 0;
        try {
            int i;
            if (this.buffer.isEmpty() && this.moreToLoad) {
                this.request.flushPersistenceContextOnIterate();
                i = -1;
                while (this.moreToLoad && ++i < this.bufferSize) {
                    if (this.cquery.hasNext()) {
                        this.buffer.add(this.cquery.next());
                        continue;
                    }
                    this.moreToLoad = false;
                }
                this.request.executeSecondaryQueries(true);
            }
            i = ret = !this.buffer.isEmpty() ? 1 : 0;
            return i != 0;
        }
        catch (SQLException e) {
            throw this.cquery.createPersistenceException(e);
        }
        finally {
            if (ret == 0) {
                this.close();
            }
        }
    }

    @Override
    public T next() {
        if (this.buffer.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buffer.remove(0);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.cquery.updateExecutionStatisticsIterator();
            this.cquery.close();
            this.request.endTransIfRequired();
        }
    }
}

