/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.Query;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.SqlLimitResponse;
import io.ebean.config.dbplatform.SqlLimiter;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.query.CQueryPredicates;
import io.ebeaninternal.server.querydefn.OrmQueryLimitRequest;
import io.ebeaninternal.server.rawsql.SpiRawSql;
import io.ebeaninternal.server.util.BindParamsParser;

final class CQueryBuilderRawSql {
    private final SqlLimiter sqlLimiter;
    private final DatabasePlatform dbPlatform;

    CQueryBuilderRawSql(SqlLimiter sqlLimiter, DatabasePlatform dbPlatform) {
        this.sqlLimiter = sqlLimiter;
        this.dbPlatform = dbPlatform;
    }

    SqlLimitResponse buildSql(OrmQueryRequest<?> request, CQueryPredicates predicates, SpiRawSql.Sql rsql) {
        if (rsql == null) {
            return new SqlLimitResponse("--ResultSetBasedRawSql");
        }
        if (!rsql.isParsed()) {
            String sql = rsql.getUnparsedSql();
            BindParams bindParams = request.getQuery().getBindParams();
            if (bindParams != null && bindParams.requiresNamedParamsPrepare()) {
                sql = BindParamsParser.parse(bindParams, sql);
            }
            return new SqlLimitResponse(sql);
        }
        String orderBy = this.getOrderBy(predicates, rsql);
        String sql = this.buildMainQuery(orderBy, request, predicates, rsql);
        Query query = request.getQuery();
        if (query.hasMaxRowsOrFirstRow() && this.sqlLimiter != null) {
            return this.sqlLimiter.limit(new OrmQueryLimitRequest(sql, orderBy, (SpiQuery<?>)query, this.dbPlatform, rsql.isDistinct() || query.isDistinct()));
        }
        String prefix = "select " + (rsql.isDistinct() ? "distinct " : "");
        sql = prefix + sql;
        return new SqlLimitResponse(sql);
    }

    private String buildMainQuery(String orderBy, OrmQueryRequest<?> request, CQueryPredicates predicates, SpiRawSql.Sql sql) {
        String dbHaving;
        String preHaving;
        String dbWhere;
        StringBuilder sb = new StringBuilder();
        sb.append(sql.getPreFrom());
        sb.append(" ");
        String s2 = sql.getPreWhere();
        BindParams bindParams = request.getQuery().getBindParams();
        if (bindParams != null && bindParams.requiresNamedParamsPrepare()) {
            s2 = BindParamsParser.parse(bindParams, s2);
        }
        sb.append(s2);
        sb.append(" ");
        String dynamicWhere = null;
        if (request.getQuery().getId() != null) {
            BeanDescriptor<?> descriptor = request.getBeanDescriptor();
            dynamicWhere = descriptor.getIdBinderIdSql(null);
        }
        if (this.hasValue(dbWhere = predicates.getDbWhere())) {
            dynamicWhere = dynamicWhere == null ? dbWhere : dynamicWhere + " and " + dbWhere;
        }
        if (this.hasValue(dynamicWhere)) {
            if (sql.isAndWhereExpr()) {
                sb.append(" and ");
            } else {
                sb.append(" where ");
            }
            sb.append(dynamicWhere);
            sb.append(" ");
        }
        if (this.hasValue(preHaving = sql.getPreHaving())) {
            sb.append(preHaving);
            sb.append(" ");
        }
        if (this.hasValue(dbHaving = predicates.getDbHaving())) {
            sb.append(" ");
            if (sql.isAndHavingExpr()) {
                sb.append("and ");
            } else {
                sb.append("having ");
            }
            sb.append(dbHaving);
            sb.append(" ");
        }
        if (this.hasValue(orderBy)) {
            sb.append(" ").append(sql.getOrderByPrefix()).append(" ").append(orderBy);
        }
        return sb.toString().trim();
    }

    private boolean hasValue(String s2) {
        return s2 != null && !s2.isEmpty();
    }

    private String getOrderBy(CQueryPredicates predicates, SpiRawSql.Sql sql) {
        String orderBy = predicates.getDbOrderBy();
        if (orderBy != null) {
            return orderBy;
        }
        return sql.getOrderBy();
    }
}

