/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.profile;

import io.ebean.metric.TimedMetricStats;

class DTimeMetricStats
implements TimedMetricStats {
    private final boolean collected;
    private final long count;
    private final long total;
    private final long max;
    private String name;
    private String location;

    DTimeMetricStats(String name, boolean collected, long count, long total, long max) {
        this.name = name;
        this.collected = collected;
        this.count = count;
        this.total = total;
        this.max = max != Long.MIN_VALUE ? max : (long)(count < 1L ? 0 : Math.round(total / count));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append("name:").append(this.name).append(" ");
        }
        sb.append("count:").append(this.count).append(" total:").append(this.total).append(" max:").append(this.max);
        if (this.location != null) {
            sb.append(" loc:").append(this.location);
        }
        return sb.toString();
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public boolean initialCollection() {
        return !this.collected;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public long total() {
        return this.total;
    }

    @Override
    public long max() {
        return this.max;
    }

    @Override
    public long mean() {
        return this.count < 1L ? 0L : Math.round((double)(this.total / this.count));
    }
}

