/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.profile;

import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetricVisitor;
import io.ebean.metric.QueryPlanMetric;
import io.ebean.metric.TimedMetric;
import io.ebean.metric.TimedMetricStats;
import io.ebeaninternal.server.profile.DQueryPlanMeta;
import io.ebeaninternal.server.profile.DTimeMetricStats;
import io.ebeaninternal.server.profile.DTimedMetric;

class DQueryPlanMetric
implements QueryPlanMetric {
    private final DQueryPlanMeta meta;
    private final DTimedMetric metric;
    private boolean collected;

    DQueryPlanMetric(DQueryPlanMeta meta, DTimedMetric metric) {
        this.meta = meta;
        this.metric = metric;
    }

    @Override
    public void visit(MetricVisitor visitor) {
        DTimeMetricStats stats = this.metric.collect(visitor.reset());
        if (stats != null) {
            visitor.visitQuery(new Stats(this.meta, stats, this.collected));
            this.collected = true;
        }
    }

    @Override
    public TimedMetric getMetric() {
        return this.metric;
    }

    private static class Stats
    implements MetaQueryMetric {
        private final DQueryPlanMeta meta;
        private final TimedMetricStats stats;
        private final boolean collected;

        private Stats(DQueryPlanMeta meta, TimedMetricStats stats, boolean collected) {
            this.meta = meta;
            this.stats = stats;
            this.collected = collected;
        }

        public String toString() {
            return this.meta + " " + this.stats + " sql:" + this.sql();
        }

        @Override
        public Class<?> type() {
            return this.meta.getType();
        }

        @Override
        public boolean initialCollection() {
            return !this.collected;
        }

        @Override
        public String hash() {
            return this.meta.getHash();
        }

        @Override
        public String label() {
            return this.meta.getLabel();
        }

        @Override
        public String sql() {
            return this.meta.getSql();
        }

        @Override
        public String name() {
            return this.meta.getName();
        }

        @Override
        public String location() {
            return this.meta.getLocation();
        }

        @Override
        public long count() {
            return this.stats.count();
        }

        @Override
        public long total() {
            return this.stats.total();
        }

        @Override
        public long max() {
            return this.stats.max();
        }

        @Override
        public long mean() {
            return this.stats.mean();
        }
    }
}

