/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.profile;

import io.ebean.ProfileLocation;
import io.ebeaninternal.server.profile.UtilLocation;

class DProfileLocation
implements ProfileLocation {
    private static final String IO_EBEAN = "io.ebean";
    private static final String UNKNOWN = "unknown";
    private String fullLocation;
    private String location;
    private String label;
    private final int lineNumber;
    private int traceCount;

    DProfileLocation() {
        this(0);
    }

    DProfileLocation(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String toString() {
        return "location: " + this.location;
    }

    @Override
    public void add(long executionTime) {
    }

    @Override
    public boolean obtain() {
        if (this.fullLocation != null) {
            return false;
        }
        String loc = this.create();
        String location = UtilLocation.loc(loc);
        this.label = UtilLocation.label(location);
        this.location = location;
        this.fullLocation = loc;
        this.initWith(this.label);
        return true;
    }

    protected void initWith(String label) {
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public String fullLocation() {
        return this.fullLocation;
    }

    @Override
    public boolean trace() {
        if (this.traceCount <= 0) {
            return false;
        }
        --this.traceCount;
        return true;
    }

    @Override
    public void setTraceCount(int traceCount) {
        this.traceCount = traceCount;
    }

    private String create() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (int i = 3; i < trace.length; ++i) {
            if (trace[i].getClassName().startsWith(IO_EBEAN)) continue;
            return this.withLineNumber(trace[i].toString());
        }
        return UNKNOWN;
    }

    private String withLineNumber(String traceLine) {
        if (this.lineNumber == 0) {
            return traceLine;
        }
        if (traceLine.endsWith(":1)")) {
            return traceLine.substring(0, traceLine.length() - 3) + ":" + this.lineNumber + ")";
        }
        if (traceLine.contains(":")) {
            return traceLine;
        }
        return traceLine.substring(0, traceLine.length() - 1) + ":" + this.lineNumber + ")";
    }
}

