/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.profile;

import io.ebean.meta.MetricVisitor;
import io.ebean.metric.CountMetric;
import io.ebean.metric.CountMetricStats;
import java.util.concurrent.atomic.LongAdder;

class DCountMetric
implements CountMetric {
    private final String name;
    private final LongAdder count = new LongAdder();

    DCountMetric(String name) {
        this.name = name;
    }

    @Override
    public void add(long value) {
        this.count.add(value);
    }

    @Override
    public void increment() {
        this.count.increment();
    }

    @Override
    public boolean isEmpty() {
        return this.count.sum() == 0L;
    }

    @Override
    public void reset() {
        this.count.reset();
    }

    @Override
    public long get(boolean reset) {
        return reset ? this.count.sumThenReset() : this.count.sum();
    }

    @Override
    public void visit(MetricVisitor visitor) {
        long val;
        long l = val = visitor.reset() ? this.count.sumThenReset() : this.count.sum();
        if (val > 0L) {
            visitor.visitCount(new DCountMetricStats(this.name, val));
        }
    }

    private static class DCountMetricStats
    implements CountMetricStats {
        private final String name;
        private final long count;

        private DCountMetricStats(String name, long count) {
            this.name = name;
            this.count = count;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public long count() {
            return this.count;
        }
    }
}

