/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebeaninternal.server.persist.BatchPostExecute;
import io.ebeaninternal.server.persist.BatchedPstmt;
import io.ebeaninternal.server.persist.BatchedSqlException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.PersistenceException;

public final class BatchedPstmtHolder {
    private Map<String, BatchedPstmt> stmtMap = new LinkedHashMap<String, BatchedPstmt>();
    private int maxSize;

    BatchedPstmtHolder() {
    }

    PreparedStatement getStmt(String stmtKey, BatchPostExecute postExecute) throws SQLException {
        BatchedPstmt batchedPstmt = this.getBatchedPstmt(stmtKey);
        return batchedPstmt == null ? null : batchedPstmt.getStatement(postExecute);
    }

    public BatchedPstmt getBatchedPstmt(String stmtKey) {
        BatchedPstmt bs = this.stmtMap.get(stmtKey);
        if (bs == null) {
            return null;
        }
        int bsSize = bs.size();
        if (bsSize > this.maxSize) {
            this.maxSize = bsSize;
        }
        return bs;
    }

    int getMaxSize() {
        return this.maxSize;
    }

    public void addStmt(BatchedPstmt bs, BatchPostExecute postExecute) {
        bs.add(postExecute);
        this.stmtMap.put(bs.getSql(), bs);
    }

    public boolean isEmpty() {
        if (this.stmtMap.isEmpty()) {
            return true;
        }
        for (BatchedPstmt bs : this.stmtMap.values()) {
            if (bs.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int[] execute(String key, boolean getGeneratedKeys) throws SQLException {
        BatchedPstmt batchedPstmt = this.stmtMap.get(key);
        if (batchedPstmt == null) {
            throw new PersistenceException("No batched statement found for key " + key);
        }
        batchedPstmt.executeBatch(getGeneratedKeys);
        return batchedPstmt.getResults();
    }

    public void flush(boolean getGeneratedKeys, boolean reset) throws BatchedSqlException {
        Map<String, BatchedPstmt> copyMap = this.stmtMap;
        Collection<BatchedPstmt> copy = copyMap.values();
        this.stmtMap = new LinkedHashMap<String, BatchedPstmt>();
        this.maxSize = 0;
        try {
            this.executeAll(copy, getGeneratedKeys);
            if (reset) {
                this.closeStatements(copy);
            } else {
                this.loadBack(copyMap);
            }
        }
        catch (BatchedSqlException e) {
            this.closeStatements(copy);
            throw e;
        }
    }

    private void loadBack(Map<String, BatchedPstmt> copyMap) {
        if (this.stmtMap.isEmpty()) {
            this.stmtMap = copyMap;
        } else {
            this.closeStatements(copyMap.values());
        }
    }

    private void executeAll(Collection<BatchedPstmt> values, boolean getGeneratedKeys) throws BatchedSqlException {
        for (BatchedPstmt bs : values) {
            try {
                bs.executeBatch(getGeneratedKeys);
            }
            catch (SQLException ex) {
                throw new BatchedSqlException("Error when batch flush on sql: " + bs.getSql(), ex);
            }
        }
    }

    public void clear() {
        this.closeStatements(this.stmtMap.values());
        this.stmtMap.clear();
        this.maxSize = 0;
    }

    private void closeStatements(Collection<BatchedPstmt> batchedStatements) {
        for (BatchedPstmt bs : batchedStatements) {
            bs.close();
        }
    }
}

