/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.grammer;

import io.ebean.FetchConfig;

class ParseFetchConfig {
    ParseFetchConfig() {
    }

    static FetchConfig parse(String path) {
        if (path.startsWith("lazy")) {
            if (path.length() == 4) {
                return FetchConfig.ofLazy();
            }
            if (path.charAt(4) == '(') {
                path = path.substring(5);
                int batchSize = ParseFetchConfig.parseBatchSize(path);
                return FetchConfig.ofLazy(batchSize);
            }
            return null;
        }
        if (path.startsWith("query")) {
            if (path.length() == 5) {
                return FetchConfig.ofQuery();
            }
            if (path.charAt(5) == '(') {
                path = path.substring(6);
                int batchSize = ParseFetchConfig.parseBatchSize(path);
                return FetchConfig.ofQuery(batchSize);
            }
            return null;
        }
        return null;
    }

    private static int parseBatchSize(String path) {
        path = path.substring(0, path.length() - 1);
        return Integer.parseInt(path);
    }
}

