/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.expression.DocQueryContext;
import io.ebeaninternal.server.expression.NonPrepareExpression;
import io.ebeaninternal.server.expression.Same;
import io.ebeaninternal.server.persist.MultiValueWrapper;
import java.io.IOException;
import java.util.Collection;

class RawExpression
extends NonPrepareExpression {
    final String sql;
    final Object[] values;

    RawExpression(String sql, Object[] values) {
        this.sql = sql;
        this.values = values;
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeRaw(this.sql, this.values);
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        if (this.values != null) {
            for (Object value : this.values) {
                if (value instanceof Collection) {
                    request.addBindValue(new MultiValueWrapper((Collection)value));
                    continue;
                }
                request.addBindValue(value);
            }
        }
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.append(this.sql);
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("Raw[").append(this.sql);
        if (this.values != null) {
            builder.append(" ?").append(this.values.length);
        }
        builder.append("]");
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.values.length);
        for (Object value : this.values) {
            key.add(value);
        }
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        if (!(other instanceof RawExpression)) {
            return false;
        }
        RawExpression that = (RawExpression)other;
        if (this.values.length != that.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (Same.sameByValue(this.values[i], that.values[i])) continue;
            return false;
        }
        return true;
    }
}

