/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.ExampleExpression;
import io.ebean.Expression;
import io.ebean.ExpressionFactory;
import io.ebean.ExpressionList;
import io.ebean.Junction;
import io.ebean.LikeType;
import io.ebean.Pairs;
import io.ebean.Query;
import io.ebean.bean.EntityBean;
import io.ebean.search.Match;
import io.ebean.search.MultiMatch;
import io.ebean.search.TextCommonTerms;
import io.ebean.search.TextQueryString;
import io.ebean.search.TextSimple;
import io.ebeaninternal.api.SpiExpressionFactory;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.expression.AllEqualsExpression;
import io.ebeaninternal.server.expression.ArrayContainsExpression;
import io.ebeaninternal.server.expression.ArrayIsEmptyExpression;
import io.ebeaninternal.server.expression.BetweenExpression;
import io.ebeaninternal.server.expression.BetweenPropertyExpression;
import io.ebeaninternal.server.expression.BitwiseExpression;
import io.ebeaninternal.server.expression.BitwiseOp;
import io.ebeaninternal.server.expression.CaseInsensitiveEqualExpression;
import io.ebeaninternal.server.expression.DefaultExampleExpression;
import io.ebeaninternal.server.expression.ExistsQueryExpression;
import io.ebeaninternal.server.expression.IdExpression;
import io.ebeaninternal.server.expression.IdInExpression;
import io.ebeaninternal.server.expression.InExpression;
import io.ebeaninternal.server.expression.InPairsExpression;
import io.ebeaninternal.server.expression.InQueryExpression;
import io.ebeaninternal.server.expression.InRangeExpression;
import io.ebeaninternal.server.expression.IsEmptyExpression;
import io.ebeaninternal.server.expression.JsonPathExpression;
import io.ebeaninternal.server.expression.JunctionExpression;
import io.ebeaninternal.server.expression.LikeExpression;
import io.ebeaninternal.server.expression.LogicExpression;
import io.ebeaninternal.server.expression.NativeILikeExpression;
import io.ebeaninternal.server.expression.NoopExpression;
import io.ebeaninternal.server.expression.NotExpression;
import io.ebeaninternal.server.expression.NullExpression;
import io.ebeaninternal.server.expression.Op;
import io.ebeaninternal.server.expression.RawExpression;
import io.ebeaninternal.server.expression.RawExpressionBuilder;
import io.ebeaninternal.server.expression.SimpleExpression;
import io.ebeaninternal.server.expression.TextCommonTermsExpression;
import io.ebeaninternal.server.expression.TextMatchExpression;
import io.ebeaninternal.server.expression.TextMultiMatchExpression;
import io.ebeaninternal.server.expression.TextQueryStringExpression;
import io.ebeaninternal.server.expression.TextSimpleExpression;
import io.ebeaninternal.server.grammer.EqlParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class DefaultExpressionFactory
implements SpiExpressionFactory {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final boolean nativeIlike;
    private final boolean equalsWithNullAsNoop;

    public DefaultExpressionFactory(boolean equalsWithNullAsNoop, boolean nativeIlike) {
        this.equalsWithNullAsNoop = equalsWithNullAsNoop;
        this.nativeIlike = nativeIlike;
    }

    @Override
    public ExpressionFactory createExpressionFactory() {
        return this;
    }

    public String getLang() {
        return "sql";
    }

    @Override
    public Expression textMatch(String propertyName, String search, Match options) {
        return new TextMatchExpression(propertyName, search, options);
    }

    @Override
    public Expression textMultiMatch(String query, MultiMatch options) {
        return new TextMultiMatchExpression(query, options);
    }

    @Override
    public Expression textSimple(String search, TextSimple options) {
        return new TextSimpleExpression(search, options);
    }

    @Override
    public Expression textQueryString(String search, TextQueryString options) {
        return new TextQueryStringExpression(search, options);
    }

    @Override
    public Expression textCommonTerms(String search, TextCommonTerms options) {
        return new TextCommonTermsExpression(search, options);
    }

    @Override
    public Expression jsonExists(String propertyName, String path) {
        return new JsonPathExpression(propertyName, path, Op.EXISTS, null);
    }

    @Override
    public Expression jsonNotExists(String propertyName, String path) {
        return new JsonPathExpression(propertyName, path, Op.NOT_EXISTS, null);
    }

    @Override
    public Expression jsonEqualTo(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.EQ, value);
    }

    @Override
    public Expression jsonNotEqualTo(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.NOT_EQ, value);
    }

    @Override
    public Expression jsonGreaterThan(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.GT, value);
    }

    @Override
    public Expression jsonGreaterOrEqual(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.GT_EQ, value);
    }

    @Override
    public Expression jsonLessThan(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.LT, value);
    }

    @Override
    public Expression jsonLessOrEqualTo(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.LT_EQ, value);
    }

    @Override
    public Expression jsonBetween(String propertyName, String path, Object lowerValue, Object upperValue) {
        return new JsonPathExpression(propertyName, path, lowerValue, upperValue);
    }

    @Override
    public Expression arrayContains(String propertyName, Object ... values) {
        return new ArrayContainsExpression(propertyName, true, values);
    }

    @Override
    public Expression arrayNotContains(String propertyName, Object ... values) {
        return new ArrayContainsExpression(propertyName, false, values);
    }

    @Override
    public Expression arrayIsEmpty(String propertyName) {
        return new ArrayIsEmptyExpression(propertyName, true);
    }

    @Override
    public Expression arrayIsNotEmpty(String propertyName) {
        return new ArrayIsEmptyExpression(propertyName, false);
    }

    @Override
    public Expression bitwiseAny(String propertyName, long flags) {
        return new BitwiseExpression(propertyName, BitwiseOp.ANY, flags, "!=", 0L);
    }

    @Override
    public Expression bitwiseAll(String propertyName, long flags) {
        return new BitwiseExpression(propertyName, BitwiseOp.ALL, flags, "=", flags);
    }

    @Override
    public Expression bitwiseAnd(String propertyName, long flags, long match) {
        return new BitwiseExpression(propertyName, BitwiseOp.AND, flags, "=", match);
    }

    @Override
    public <T> void where(ExpressionList<T> list, String expressions, Object[] params) {
        EqlParser.parseWhere(expressions, list, this, params);
    }

    @Override
    public Expression eq(String propertyName, Object value) {
        if (value == null) {
            return this.equalsWithNullAsNoop ? NoopExpression.INSTANCE : this.isNull(propertyName);
        }
        return new SimpleExpression(propertyName, Op.EQ, value);
    }

    @Override
    public Expression eqOrNull(String propertyName, Object value) {
        return this.or(this.eq(propertyName, value), this.isNull(propertyName));
    }

    @Override
    public Expression ne(String propertyName, Object value) {
        if (value == null) {
            return this.equalsWithNullAsNoop ? NoopExpression.INSTANCE : this.isNotNull(propertyName);
        }
        return new SimpleExpression(propertyName, Op.NOT_EQ, value);
    }

    @Override
    public Expression ieq(String propertyName, String value) {
        if (value == null) {
            return this.equalsWithNullAsNoop ? NoopExpression.INSTANCE : this.isNull(propertyName);
        }
        return new CaseInsensitiveEqualExpression(propertyName, value, false);
    }

    @Override
    public Expression ine(String propertyName, String value) {
        if (value == null) {
            return this.equalsWithNullAsNoop ? NoopExpression.INSTANCE : this.isNotNull(propertyName);
        }
        return new CaseInsensitiveEqualExpression(propertyName, value, true);
    }

    @Override
    public Expression ieqObject(String propertyName, Object value) {
        return new CaseInsensitiveEqualExpression(propertyName, value, false);
    }

    @Override
    public Expression ineObject(String propertyName, Object value) {
        return new CaseInsensitiveEqualExpression(propertyName, value, true);
    }

    @Override
    public Expression inRange(String propertyName, Object value1, Object value2) {
        return new InRangeExpression(propertyName, value1, value2);
    }

    @Override
    public Expression inRangeWith(String lowProperty, String highProperty, Object value) {
        return this.and(this.le(lowProperty, value), this.gtOrNull(highProperty, value));
    }

    @Override
    public Expression between(String propertyName, Object value1, Object value2) {
        return new BetweenExpression(propertyName, value1, value2);
    }

    @Override
    public Expression betweenProperties(String lowProperty, String highProperty, Object value) {
        return new BetweenPropertyExpression(lowProperty, highProperty, value);
    }

    @Override
    public Expression gt(String propertyName, Object value) {
        return new SimpleExpression(propertyName, Op.GT, value);
    }

    @Override
    public Expression gtOrNull(String propertyName, Object value) {
        return this.or(this.gt(propertyName, value), this.isNull(propertyName));
    }

    @Override
    public Expression geOrNull(String propertyName, Object value) {
        return this.or(this.ge(propertyName, value), this.isNull(propertyName));
    }

    @Override
    public Expression ge(String propertyName, Object value) {
        return new SimpleExpression(propertyName, Op.GT_EQ, value);
    }

    @Override
    public Expression ltOrNull(String propertyName, Object value) {
        return this.or(this.lt(propertyName, value), this.isNull(propertyName));
    }

    @Override
    public Expression leOrNull(String propertyName, Object value) {
        return this.or(this.le(propertyName, value), this.isNull(propertyName));
    }

    @Override
    public Expression lt(String propertyName, Object value) {
        return new SimpleExpression(propertyName, Op.LT, value);
    }

    @Override
    public Expression le(String propertyName, Object value) {
        return new SimpleExpression(propertyName, Op.LT_EQ, value);
    }

    @Override
    public Expression isNull(String propertyName) {
        return new NullExpression(propertyName, false);
    }

    @Override
    public Expression isNotNull(String propertyName) {
        return new NullExpression(propertyName, true);
    }

    private EntityBean checkEntityBean(Object bean) {
        if (!(bean instanceof EntityBean)) {
            throw new IllegalStateException("Expecting an EntityBean");
        }
        return (EntityBean)bean;
    }

    @Override
    public ExampleExpression iexampleLike(Object example) {
        return new DefaultExampleExpression(this.checkEntityBean(example), true, LikeType.RAW);
    }

    @Override
    public ExampleExpression exampleLike(Object example) {
        return new DefaultExampleExpression(this.checkEntityBean(example), false, LikeType.RAW);
    }

    @Override
    public ExampleExpression exampleLike(Object example, boolean caseInsensitive, LikeType likeType) {
        return new DefaultExampleExpression(this.checkEntityBean(example), caseInsensitive, likeType);
    }

    @Override
    public Expression like(String propertyName, Object value, boolean caseInsensitive, LikeType likeType) {
        return new LikeExpression(propertyName, value, caseInsensitive, likeType);
    }

    @Override
    public Expression like(String propertyName, String value) {
        return new LikeExpression(propertyName, value, false, LikeType.RAW);
    }

    @Override
    public Expression ilike(String propertyName, String value) {
        if (this.nativeIlike) {
            return new NativeILikeExpression(propertyName, value);
        }
        return new LikeExpression(propertyName, value, true, LikeType.RAW);
    }

    @Override
    public Expression startsWith(String propertyName, String value) {
        return new LikeExpression(propertyName, value, false, LikeType.STARTS_WITH);
    }

    @Override
    public Expression istartsWith(String propertyName, String value) {
        return new LikeExpression(propertyName, value, true, LikeType.STARTS_WITH);
    }

    @Override
    public Expression endsWith(String propertyName, String value) {
        return new LikeExpression(propertyName, value, false, LikeType.ENDS_WITH);
    }

    @Override
    public Expression iendsWith(String propertyName, String value) {
        return new LikeExpression(propertyName, value, true, LikeType.ENDS_WITH);
    }

    @Override
    public Expression contains(String propertyName, String value) {
        return new LikeExpression(propertyName, value, false, LikeType.CONTAINS);
    }

    @Override
    public Expression icontains(String propertyName, String value) {
        return new LikeExpression(propertyName, value, true, LikeType.CONTAINS);
    }

    @Override
    public Expression inPairs(Pairs pairs) {
        return new InPairsExpression(pairs, false);
    }

    @Override
    public Expression in(String propertyName, Object[] values) {
        return new InExpression(propertyName, values, false);
    }

    @Override
    public Expression in(String propertyName, Query<?> subQuery) {
        return new InQueryExpression(propertyName, (SpiQuery)subQuery, false);
    }

    @Override
    public Expression in(String propertyName, Collection<?> values) {
        return new InExpression(propertyName, values, false);
    }

    @Override
    public Expression inOrEmpty(String propertyName, Collection<?> values) {
        return new InExpression(propertyName, values, false, true);
    }

    @Override
    public Expression notIn(String propertyName, Object[] values) {
        return new InExpression(propertyName, values, true);
    }

    @Override
    public Expression notIn(String propertyName, Collection<?> values) {
        return new InExpression(propertyName, values, true);
    }

    @Override
    public Expression notIn(String propertyName, Query<?> subQuery) {
        return new InQueryExpression(propertyName, (SpiQuery)subQuery, true);
    }

    @Override
    public Expression exists(Query<?> subQuery) {
        return new ExistsQueryExpression((SpiQuery)subQuery, false);
    }

    @Override
    public Expression notExists(Query<?> subQuery) {
        return new ExistsQueryExpression((SpiQuery)subQuery, true);
    }

    @Override
    public Expression isEmpty(String propertyName) {
        return new IsEmptyExpression(propertyName, true);
    }

    @Override
    public Expression isNotEmpty(String propertyName) {
        return new IsEmptyExpression(propertyName, false);
    }

    @Override
    public Expression idEq(Object value) {
        if (value == null) {
            throw new NullPointerException("The id value is null");
        }
        return new IdExpression(value);
    }

    @Override
    public Expression idIn(Collection<?> idCollection) {
        return new IdInExpression(idCollection);
    }

    @Override
    public Expression idIn(Object ... idValues) {
        return new IdInExpression(Arrays.asList(idValues));
    }

    @Override
    public Expression allEq(Map<String, Object> propertyMap) {
        return new AllEqualsExpression(propertyMap);
    }

    @Override
    public Expression raw(String raw, Object value) {
        return RawExpressionBuilder.buildSingle(raw, value);
    }

    @Override
    public Expression raw(String raw, Object[] values) {
        return RawExpressionBuilder.build(raw, values);
    }

    @Override
    public Expression raw(String raw) {
        return new RawExpression(raw, EMPTY_ARRAY);
    }

    @Override
    public Expression and(Expression expOne, Expression expTwo) {
        return new LogicExpression.And(expOne, expTwo);
    }

    @Override
    public Expression or(Expression expOne, Expression expTwo) {
        return new LogicExpression.Or(expOne, expTwo);
    }

    @Override
    public Expression not(Expression exp) {
        return new NotExpression(exp);
    }

    @Override
    public <T> Junction<T> conjunction(Query<T> query) {
        return new JunctionExpression<T>(Junction.Type.AND, query, query.where());
    }

    @Override
    public <T> Junction<T> disjunction(Query<T> query) {
        return new JunctionExpression<T>(Junction.Type.OR, query, query.where());
    }

    @Override
    public <T> Junction<T> conjunction(Query<T> query, ExpressionList<T> parent) {
        return new JunctionExpression<T>(Junction.Type.AND, query, parent);
    }

    @Override
    public <T> Junction<T> disjunction(Query<T> query, ExpressionList<T> parent) {
        return new JunctionExpression<T>(Junction.Type.OR, query, parent);
    }

    public <T> Junction<T> junction(Junction.Type type, Query<T> query) {
        return new JunctionExpression<T>(type, query, query.where());
    }

    @Override
    public <T> Junction<T> junction(Junction.Type type, Query<T> query, ExpressionList<T> parent) {
        return new JunctionExpression<T>(type, query, parent);
    }
}

