/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.expression.AbstractExpression;
import io.ebeaninternal.server.expression.BitwiseOp;
import io.ebeaninternal.server.expression.DocQueryContext;
import java.io.IOException;

class BitwiseExpression
extends AbstractExpression {
    protected final BitwiseOp operator;
    private final String compare;
    protected final long flags;
    private final long match;

    BitwiseExpression(String propertyName, BitwiseOp operator, long flags, String compare, long match) {
        super(propertyName);
        this.operator = operator;
        this.flags = flags;
        this.compare = compare;
        this.match = match;
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        throw new IllegalStateException("Not supported for document queries");
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("Bitwise[");
        builder.append(this.propName).append(" op:").append((Object)this.operator).append(" cp:").append(this.compare);
        builder.append(" ?2]");
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.flags).add(this.match);
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        BitwiseExpression that = (BitwiseExpression)other;
        return this.operator == that.operator && this.compare.equals(that.compare) && this.flags == that.flags && this.match == that.match;
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.getDbPlatformHandler().bitwise(request, this.propName, this.operator, this.flags, this.compare, this.match);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        request.addBindValue(this.flags);
        request.addBindValue(this.match);
    }
}

