/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.util.SplitName;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.el.ElPropertyDeploy;
import io.ebeaninternal.server.expression.DocQueryContext;
import io.ebeaninternal.server.expression.NamedParamHelp;
import io.ebeaninternal.server.expression.NonPrepareExpression;
import io.ebeaninternal.server.expression.Op;
import java.io.IOException;

class BetweenPropertyExpression
extends NonPrepareExpression {
    private static final String BETWEEN = " between ";
    private String lowProperty;
    private String highProperty;
    private final Object value;

    BetweenPropertyExpression(String lowProperty, String highProperty, Object value) {
        this.lowProperty = lowProperty;
        this.highProperty = highProperty;
        this.value = value;
    }

    @Override
    public void prefixProperty(String path) {
        this.lowProperty = path + "." + this.lowProperty;
        this.highProperty = path + "." + this.highProperty;
    }

    protected String name(String propName) {
        return propName;
    }

    private Object val() {
        return NamedParamHelp.value(this.value);
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.startBoolMust();
        context.writeSimple(Op.LT_EQ, this.lowProperty, this.val());
        context.writeSimple(Op.GT_EQ, this.highProperty, this.val());
        context.endBool();
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        ElPropertyDeploy elProp = desc.getElPropertyDeploy(this.name(this.lowProperty));
        if (elProp != null && elProp.containsMany()) {
            return SplitName.begin(this.lowProperty);
        }
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        ElPropertyDeploy elProp = desc.getElPropertyDeploy(this.name(this.lowProperty));
        if (elProp != null && elProp.containsMany()) {
            manyWhereJoin.add(elProp);
        }
        if ((elProp = desc.getElPropertyDeploy(this.name(this.highProperty))) != null && elProp.containsMany()) {
            manyWhereJoin.add(elProp);
        }
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
        validation.validate(this.lowProperty);
        validation.validate(this.highProperty);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        request.addBindValue(this.val());
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.append(" ?").append(BETWEEN).append(this.name(this.lowProperty)).append(" and ").append(this.name(this.highProperty));
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("BetweenProperties[").append("low:").append(this.lowProperty).append(" high:").append(this.highProperty).append("]");
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.val());
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        BetweenPropertyExpression that = (BetweenPropertyExpression)other;
        return this.val().equals(that.val());
    }
}

