/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.el.ElPropertyDeploy;
import io.ebeaninternal.server.expression.DocQueryContext;
import io.ebeaninternal.server.expression.NonPrepareExpression;
import io.ebeaninternal.server.expression.Same;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

class AllEqualsExpression
extends NonPrepareExpression {
    private final Map<String, Object> propMap;

    AllEqualsExpression(Map<String, Object> propMap) {
        this.propMap = propMap;
    }

    protected String name(String propName) {
        return propName;
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeAllEquals(this.propMap);
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        if (this.propMap != null) {
            for (String propertyName : this.propMap.keySet()) {
                ElPropertyDeploy elProp = desc.getElPropertyDeploy(this.name(propertyName));
                if (elProp == null || !elProp.containsMany()) continue;
                manyWhereJoin.add(elProp);
            }
        }
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
        for (String propName : this.propMap.keySet()) {
            validation.validate(propName);
        }
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        if (this.propMap.isEmpty()) {
            return;
        }
        for (Object value : this.propMap.values()) {
            if (value == null) continue;
            request.addBindValue(value);
        }
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        if (this.propMap.isEmpty()) {
            return;
        }
        request.append("(");
        int count = 0;
        for (Map.Entry<String, Object> entry : this.propMap.entrySet()) {
            Object value = entry.getValue();
            String propName = entry.getKey();
            if (count > 0) {
                request.append("and ");
            }
            request.append(this.name(propName));
            if (value == null) {
                request.append(" is null ");
            } else {
                request.append(" = ? ");
            }
            ++count;
        }
        request.append(")");
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("AllEquals[");
        for (Map.Entry<String, Object> entry : this.propMap.entrySet()) {
            Object value = entry.getValue();
            String propName = entry.getKey();
            builder.append(propName);
            if (value == null) {
                builder.append(" isNull");
            } else {
                builder.append(" =?");
            }
            builder.append(",");
        }
        builder.append("]");
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.propMap.size());
        for (Object value : this.propMap.values()) {
            key.add(value);
        }
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        if (!(other instanceof AllEqualsExpression)) {
            return false;
        }
        AllEqualsExpression that = (AllEqualsExpression)other;
        return this.isSameByValue(that, true);
    }

    private boolean isSameByValue(AllEqualsExpression that, boolean byValue) {
        if (this.propMap.size() != that.propMap.size()) {
            return false;
        }
        Iterator<Map.Entry<String, Object>> thisIt = this.propMap.entrySet().iterator();
        Iterator<Map.Entry<String, Object>> thatIt = that.propMap.entrySet().iterator();
        while (thisIt.hasNext() && thatIt.hasNext()) {
            Map.Entry<String, Object> thisNext = thisIt.next();
            Map.Entry<String, Object> thatNext = thatIt.next();
            if (!thisNext.getKey().equals(thatNext.getKey())) {
                return false;
            }
            if (Same.sameBy(byValue, thisNext.getValue(), thatNext.getValue())) continue;
            return false;
        }
        return true;
    }
}

