/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.executor;

import io.ebeaninternal.api.SpiBackgroundExecutor;
import io.ebeaninternal.server.executor.DaemonScheduleThreadPool;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.MDC;

public class DefaultBackgroundExecutor
implements SpiBackgroundExecutor {
    private final ScheduledExecutorService executor;

    public DefaultBackgroundExecutor(int schedulePoolSize, int shutdownWaitSeconds, String namePrefix) {
        this.executor = new DaemonScheduleThreadPool(schedulePoolSize, shutdownWaitSeconds, namePrefix);
    }

    <T> Callable<T> wrapMDC(Callable<T> task) {
        Map<String, String> map = MDC.getCopyOfContextMap();
        if (map == null) {
            return task;
        }
        return () -> {
            MDC.setContextMap(map);
            try {
                Object v = task.call();
                return v;
            }
            finally {
                MDC.clear();
            }
        };
    }

    Runnable wrapMDC(Runnable task) {
        Map<String, String> map = MDC.getCopyOfContextMap();
        if (map == null) {
            return task;
        }
        return () -> {
            MDC.setContextMap(map);
            try {
                task.run();
            }
            finally {
                MDC.clear();
            }
        };
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(this.wrapMDC(task));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executor.submit(this.wrapMDC(task));
    }

    @Override
    public void execute(Runnable task) {
        this.submit(task);
    }

    @Override
    public void executePeriodically(Runnable task, long delay, TimeUnit unit) {
        this.executor.scheduleWithFixedDelay(this.wrapMDC(task), delay, delay, unit);
    }

    @Override
    public void executePeriodically(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        this.executor.scheduleWithFixedDelay(this.wrapMDC(task), initialDelay, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return this.executor.scheduleWithFixedDelay(this.wrapMDC(task), initialDelay, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(this.wrapMDC(task), initialDelay, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        return this.executor.schedule(this.wrapMDC(task), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
        return this.executor.schedule(this.wrapMDC(task), delay, unit);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }
}

