/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.dto;

import io.ebeaninternal.server.dto.DtoMeta;
import io.ebeaninternal.server.dto.DtoMetaConstructor;
import io.ebeaninternal.server.dto.DtoMetaProperty;
import io.ebeaninternal.server.type.TypeManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DtoMetaBuilder {
    private static final Logger log = LoggerFactory.getLogger(DtoMetaBuilder.class);
    private final TypeManager typeManager;
    private final Class<?> dtoType;
    private final List<DtoMetaProperty> properties = new ArrayList<DtoMetaProperty>();
    private final List<DtoMetaConstructor> constructorList = new ArrayList<DtoMetaConstructor>();

    DtoMetaBuilder(Class<?> dtoType, TypeManager typeManager) {
        this.dtoType = dtoType;
        this.typeManager = typeManager;
    }

    DtoMeta build() {
        this.readConstructors();
        this.readProperties();
        return new DtoMeta(this.dtoType, this.constructorList, this.properties);
    }

    private void readProperties() {
        for (Method method : this.dtoType.getMethods()) {
            if (!DtoMetaBuilder.includeMethod(method)) continue;
            try {
                String name = DtoMetaBuilder.propertyName(method.getName());
                Class<?> propertyType = DtoMetaBuilder.propertyType(method);
                this.properties.add(new DtoMetaProperty(this.typeManager, this.dtoType, method, name, propertyType));
            }
            catch (Exception e) {
                log.debug("exclude on " + this.dtoType + " method " + method, e);
            }
        }
    }

    static Class<?> propertyType(Method method) {
        return method.getParameterTypes()[0];
    }

    static String propertyName(String methodName) {
        String name = methodName.substring(3);
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    static boolean includeMethod(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Void.TYPE.equals(method.getReturnType()) && method.getParameterTypes().length == 1 && method.getName().startsWith("set") && method.getName().length() > 3;
    }

    private void readConstructors() {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = this.dtoType.getConstructors()) {
            try {
                this.constructorList.add(new DtoMetaConstructor(this.typeManager, constructor, this.dtoType));
            }
            catch (Exception e) {
                log.debug("exclude on " + this.dtoType + " constructor " + constructor, e);
            }
        }
    }
}

