/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.dto;

import io.ebean.ProfileLocation;
import io.ebean.metric.MetricFactory;
import io.ebean.metric.QueryPlanMetric;
import io.ebeaninternal.api.SpiDtoQuery;
import io.ebeaninternal.server.dto.DtoColumn;
import io.ebeaninternal.server.dto.DtoMeta;
import io.ebeaninternal.server.dto.DtoReadSet;
import io.ebeaninternal.server.dto.DtoReadSetColumnSkip;

public class DtoMappingRequest {
    private final Class type;
    private final String label;
    private final ProfileLocation profileLocation;
    private final String sql;
    private final boolean relaxedMode;
    private final DtoColumn[] columnMeta;

    public DtoMappingRequest(SpiDtoQuery query, String sql, DtoColumn[] columnMeta) {
        this.type = query.getType();
        this.label = query.getPlanLabel();
        this.profileLocation = query.getProfileLocation();
        this.sql = sql;
        this.relaxedMode = query.isRelaxedMode();
        this.columnMeta = columnMeta;
    }

    public DtoColumn[] getColumnMeta() {
        return this.columnMeta;
    }

    public boolean isRelaxedMode() {
        return this.relaxedMode;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSql() {
        return this.sql;
    }

    public QueryPlanMetric createMetric() {
        return MetricFactory.get().createQueryPlanMetric(this.type, this.label, this.profileLocation, this.sql);
    }

    DtoReadSet[] mapSetters(DtoMeta meta) {
        DtoReadSet[] setterProps = new DtoReadSet[this.columnMeta.length];
        for (int i = 0; i < this.columnMeta.length; ++i) {
            setterProps[i] = this.mapColumn(i, meta);
        }
        return setterProps;
    }

    DtoReadSet[] mapArgPlusSetters(DtoMeta meta, int firstOnes) {
        DtoReadSet[] setterProps = new DtoReadSet[this.columnMeta.length - firstOnes];
        int pos = 0;
        for (int i = firstOnes; i < this.columnMeta.length; ++i) {
            setterProps[pos++] = this.mapColumn(i, meta);
        }
        return setterProps;
    }

    private DtoReadSet mapColumn(int pos, DtoMeta meta) {
        String label = this.columnMeta[pos].getLabel();
        DtoReadSet property = meta.findProperty(label);
        if (property == null || property.isReadOnly()) {
            if (this.isRelaxedMode()) {
                property = DtoReadSetColumnSkip.INSTANCE;
            } else {
                throw new IllegalStateException(this.unableToMapColumnMessage(this.columnMeta[pos], meta));
            }
        }
        return property;
    }

    private String unableToMapColumnMessage(DtoColumn col, DtoMeta meta) {
        return "Unable to map DB column " + col + " to a property with a setter method on " + meta.dtoType() + ". Consider query.setRelaxedMode() to skip mapping this column.";
    }
}

