/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.dto;

import io.ebean.meta.MetricVisitor;
import io.ebeaninternal.server.dto.DtoMappingRequest;
import io.ebeaninternal.server.dto.DtoMeta;
import io.ebeaninternal.server.dto.DtoQueryPlan;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DtoBeanDescriptor<T> {
    private final Map<Object, DtoQueryPlan> plans = new ConcurrentHashMap<Object, DtoQueryPlan>();
    private final Class<T> dtoType;
    private final DtoMeta meta;
    private final Map<String, String> namedQueries;

    DtoBeanDescriptor(Class<T> dtoType, DtoMeta meta, Map<String, String> namedQueries) {
        this.dtoType = dtoType;
        this.meta = meta;
        this.namedQueries = namedQueries;
    }

    public Class<T> getType() {
        return this.dtoType;
    }

    public DtoQueryPlan getQueryPlan(Object planKey) {
        return this.plans.get(planKey);
    }

    public DtoQueryPlan buildPlan(DtoMappingRequest request) {
        return this.meta.match(request);
    }

    public void putQueryPlan(Object planKey, DtoQueryPlan plan) {
        this.plans.put(planKey, plan);
    }

    public void visit(MetricVisitor visitor) {
        for (DtoQueryPlan plan : this.plans.values()) {
            plan.visit(visitor);
        }
    }

    public String getNamedRawSql(String name) {
        return this.namedQueries.get(name);
    }
}

