/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.parse;

import io.ebean.Model;
import io.ebean.annotation.DbArray;
import io.ebean.annotation.DbJson;
import io.ebean.annotation.DbJsonB;
import io.ebean.annotation.DbMap;
import io.ebean.annotation.UnmappedJson;
import io.ebean.core.type.ScalarType;
import io.ebean.util.AnnotationUtil;
import io.ebeaninternal.server.deploy.DetermineManyType;
import io.ebeaninternal.server.deploy.ManyType;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertySimpleCollection;
import io.ebeaninternal.server.type.TypeManager;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import javax.persistence.PersistenceException;
import javax.persistence.Transient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployCreateProperties {
    private static final Logger logger = LoggerFactory.getLogger(DeployCreateProperties.class);
    private final DetermineManyType determineManyType;
    private final TypeManager typeManager;

    public DeployCreateProperties(TypeManager typeManager) {
        this.typeManager = typeManager;
        this.determineManyType = new DetermineManyType();
    }

    public void createProperties(DeployBeanDescriptor<?> desc) {
        this.createProperties(desc, desc.getBeanType(), 0);
        desc.sortProperties();
    }

    private boolean ignoreFieldByName(String fieldName) {
        if (fieldName.startsWith("_ebean_")) {
            return true;
        }
        return fieldName.startsWith("ajc$instance$");
    }

    private boolean ignoreField(Field field) {
        return Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || this.ignoreFieldByName(field.getName());
    }

    private void createProperties(DeployBeanDescriptor<?> desc, Class<?> beanType, int level) {
        if (beanType.equals(Model.class)) {
            return;
        }
        try {
            Field[] fields = beanType.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                DeployBeanProperty prop;
                Field field = fields[i];
                if (this.ignoreField(field) || (prop = this.createProp(desc, field, beanType)) == null) continue;
                int sortOverride = prop.getSortOverride();
                prop.setSortOrder(level * 10000 + 100 - i + sortOverride);
                DeployBeanProperty replaced = desc.addBeanProperty(prop);
                if (replaced == null || replaced.isTransient()) continue;
                String msg = "Huh??? property " + prop.getFullBeanName() + " being defined twice";
                msg = msg + " but replaced property was not transient? This is not expected?";
                logger.warn(msg);
            }
            Class<?> superClass = beanType.getSuperclass();
            if (!superClass.equals(Object.class)) {
                this.createProperties(desc, superClass, level + 1);
            }
        }
        catch (PersistenceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PersistenceException(ex);
        }
    }

    private DeployBeanProperty createManyType(DeployBeanDescriptor<?> desc, Class<?> targetType, ManyType manyType) {
        try {
            ScalarType<?> scalarType = this.typeManager.getScalarType(targetType);
            if (scalarType != null) {
                return new DeployBeanPropertySimpleCollection(desc, targetType, manyType);
            }
        }
        catch (NullPointerException e) {
            logger.debug("expected non-scalar type {}", (Object)e.getMessage());
        }
        return new DeployBeanPropertyAssocMany(desc, targetType, manyType);
    }

    private DeployBeanProperty createProp(DeployBeanDescriptor<?> desc, Field field) {
        Class<?> propertyType = field.getType();
        if (this.isSpecialScalarType(field)) {
            return new DeployBeanProperty(desc, propertyType, field.getGenericType());
        }
        ManyType manyType = this.determineManyType.getManyType(propertyType);
        if (manyType != null) {
            Class<?> targetType = this.determineTargetType(field);
            if (targetType == null) {
                if (AnnotationUtil.has(field, Transient.class)) {
                    return null;
                }
                logger.warn("Could not find parameter type (via reflection) on " + desc.getFullName() + " " + field.getName());
            }
            return this.createManyType(desc, targetType, manyType);
        }
        if (propertyType.isEnum() || propertyType.isPrimitive()) {
            return new DeployBeanProperty(desc, propertyType, null, null);
        }
        ScalarType<?> scalarType = this.typeManager.getScalarType(propertyType);
        if (scalarType != null) {
            return new DeployBeanProperty(desc, propertyType, scalarType, null);
        }
        if (this.isTransientField(field)) {
            return new DeployBeanProperty(desc, propertyType, null, null);
        }
        try {
            return new DeployBeanPropertyAssocOne(desc, propertyType);
        }
        catch (Exception e) {
            logger.error("Error with " + desc + " field:" + field.getName(), e);
            return null;
        }
    }

    private boolean isSpecialScalarType(Field field) {
        return AnnotationUtil.has(field, DbJson.class) || AnnotationUtil.has(field, DbJsonB.class) || AnnotationUtil.has(field, DbArray.class) || AnnotationUtil.has(field, DbMap.class) || AnnotationUtil.has(field, UnmappedJson.class);
    }

    private boolean isTransientField(Field field) {
        return AnnotationUtil.has(field, Transient.class);
    }

    private DeployBeanProperty createProp(DeployBeanDescriptor<?> desc, Field field, Class<?> beanType) {
        DeployBeanProperty prop = this.createProp(desc, field);
        if (prop == null) {
            return null;
        }
        prop.setOwningType(beanType);
        prop.setName(field.getName());
        prop.setField(field);
        return prop;
    }

    private Class<?> determineTargetType(Field field) {
        Type genType = field.getGenericType();
        if (genType instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)genType;
            Type[] typeArgs = ptype.getActualTypeArguments();
            if (typeArgs.length == 1) {
                Type[] upperBounds;
                if (typeArgs[0] instanceof Class) {
                    return (Class)typeArgs[0];
                }
                if (typeArgs[0] instanceof WildcardType && (upperBounds = ((WildcardType)typeArgs[0]).getUpperBounds()).length == 1 && upperBounds[0] instanceof Class) {
                    return (Class)upperBounds[0];
                }
                return null;
            }
            if (typeArgs.length == 2) {
                if (typeArgs[1] instanceof ParameterizedType) {
                    return null;
                }
                if (typeArgs[1] instanceof WildcardType) {
                    return Object.class;
                }
                return (Class)typeArgs[1];
            }
        }
        return null;
    }
}

