/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.meta;

import io.ebeaninternal.server.deploy.BeanTable;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.meta.DeployTableJoinColumn;
import io.ebeaninternal.server.deploy.parse.DeployUtil;
import io.ebeaninternal.server.query.SqlJoinType;
import java.util.ArrayList;
import java.util.Set;
import javax.persistence.JoinColumn;

public class DeployTableJoin {
    private String table;
    private SqlJoinType type = SqlJoinType.INNER;
    private ArrayList<DeployTableJoinColumn> columns = new ArrayList(4);
    private InheritInfo inheritInfo;
    private String extraWhere;

    public String toString() {
        return (Object)((Object)this.type) + " " + this.table + " " + this.columns;
    }

    public boolean hasJoinColumns() {
        return !this.columns.isEmpty();
    }

    public void setColumns(DeployTableJoinColumn[] cols, boolean reverse) {
        this.columns = new ArrayList();
        for (DeployTableJoinColumn col : cols) {
            this.addJoinColumn(col.copy(reverse));
        }
    }

    public void addJoinColumn(DeployTableJoinColumn pair) {
        this.columns.add(pair);
    }

    public void addJoinColumn(DeployUtil deploy, boolean order, JoinColumn jc, BeanTable beanTable) {
        if (!"".equals(jc.table())) {
            this.setTable(deploy.convertQuotes(jc.table()));
        }
        if (!"".equals(jc.name()) || !"".equals(jc.referencedColumnName())) {
            String ref = deploy.convertQuotes(jc.referencedColumnName());
            String nam = deploy.convertQuotes(jc.name());
            this.addJoinColumn(new DeployTableJoinColumn(order, ref, nam, jc.insertable(), jc.updatable(), beanTable));
        }
    }

    public void addJoinColumn(DeployUtil util, boolean order, JoinColumn[] jcArray, BeanTable beanTable) {
        for (JoinColumn aJcArray : jcArray) {
            this.addJoinColumn(util, order, aJcArray, beanTable);
        }
    }

    public void addJoinColumn(DeployUtil util, boolean order, Set<JoinColumn> joinColumns, BeanTable beanTable) {
        for (JoinColumn joinColumn : joinColumns) {
            this.addJoinColumn(util, order, joinColumn, beanTable);
        }
    }

    public DeployTableJoinColumn[] columns() {
        return this.columns.toArray(new DeployTableJoinColumn[0]);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public SqlJoinType getType() {
        return this.type;
    }

    public void setType(SqlJoinType type) {
        this.type = type;
    }

    public String getExtraWhere() {
        return this.extraWhere;
    }

    public void setExtraWhere(String extraWhere) {
        this.extraWhere = extraWhere;
    }

    public DeployTableJoin createInverse(String tableName) {
        DeployTableJoin inverse = new DeployTableJoin();
        return this.copyInternal(inverse, true, tableName, true);
    }

    public void copyTo(DeployTableJoin destJoin, boolean reverse, String tableName) {
        this.copyInternal(destJoin, reverse, tableName, true);
    }

    public void copyWithoutType(DeployTableJoin destJoin, boolean reverse, String tableName) {
        this.copyInternal(destJoin, reverse, tableName, false);
    }

    private DeployTableJoin copyInternal(DeployTableJoin destJoin, boolean reverse, String tableName, boolean withType) {
        destJoin.setTable(tableName);
        if (withType) {
            destJoin.setType(this.type);
        }
        destJoin.setColumns(this.columns(), reverse);
        return destJoin;
    }

    public InheritInfo getInheritInfo() {
        return this.inheritInfo;
    }

    public void setInheritInfo(InheritInfo inheritInfo) {
        this.inheritInfo = inheritInfo;
    }

    void setLocalColumn(String dbColumn) {
        if (this.columns.size() == 1) {
            this.columns.get(0).setLocalDbColumn(dbColumn);
        }
    }

    public void clear() {
        this.columns.clear();
    }
}

