/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.event.BeanPostLoad;
import java.util.ArrayList;
import java.util.List;

public class ChainedBeanPostLoad
implements BeanPostLoad {
    private final List<BeanPostLoad> list;
    private final BeanPostLoad[] chain;

    public ChainedBeanPostLoad(List<BeanPostLoad> list) {
        this.list = list;
        this.chain = list.toArray(new BeanPostLoad[0]);
    }

    public ChainedBeanPostLoad register(BeanPostLoad c) {
        if (this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanPostLoad> newList = new ArrayList<BeanPostLoad>(this.list);
        newList.add(c);
        return new ChainedBeanPostLoad(newList);
    }

    public ChainedBeanPostLoad deregister(BeanPostLoad c) {
        if (!this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanPostLoad> newList = new ArrayList<BeanPostLoad>(this.list);
        newList.remove(c);
        return new ChainedBeanPostLoad(newList);
    }

    protected int size() {
        return this.chain.length;
    }

    @Override
    public boolean isRegisterFor(Class<?> cls) {
        return false;
    }

    @Override
    public void postLoad(Object bean) {
        for (BeanPostLoad aChain : this.chain) {
            aChain.postLoad(bean);
        }
    }
}

