/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.event.BeanPersistListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ChainedBeanPersistListener
implements BeanPersistListener {
    private final List<BeanPersistListener> list;
    private final BeanPersistListener[] chain;

    ChainedBeanPersistListener(BeanPersistListener c1, BeanPersistListener c2) {
        this(ChainedBeanPersistListener.addList(c1, c2));
    }

    protected int size() {
        return this.chain.length;
    }

    @Override
    public boolean isRegisterFor(Class<?> cls) {
        return false;
    }

    private static List<BeanPersistListener> addList(BeanPersistListener c1, BeanPersistListener c2) {
        ArrayList<BeanPersistListener> addList = new ArrayList<BeanPersistListener>(2);
        addList.add(c1);
        addList.add(c2);
        return addList;
    }

    public ChainedBeanPersistListener(List<BeanPersistListener> list) {
        this.list = list;
        this.chain = list.toArray(new BeanPersistListener[0]);
    }

    public ChainedBeanPersistListener register(BeanPersistListener c) {
        if (this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanPersistListener> newList = new ArrayList<BeanPersistListener>(this.list);
        newList.add(c);
        return new ChainedBeanPersistListener(newList);
    }

    public ChainedBeanPersistListener deregister(BeanPersistListener c) {
        if (!this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanPersistListener> newList = new ArrayList<BeanPersistListener>(this.list);
        newList.remove(c);
        return new ChainedBeanPersistListener(newList);
    }

    @Override
    public void deleted(Object bean) {
        for (BeanPersistListener aChain : this.chain) {
            aChain.deleted(bean);
        }
    }

    @Override
    public void softDeleted(Object bean) {
        for (BeanPersistListener aChain : this.chain) {
            aChain.softDeleted(bean);
        }
    }

    @Override
    public void inserted(Object bean) {
        for (BeanPersistListener aChain : this.chain) {
            aChain.inserted(bean);
        }
    }

    @Override
    public void updated(Object bean, Set<String> updatedProperties) {
        for (BeanPersistListener aChain : this.chain) {
            aChain.updated(bean, updatedProperties);
        }
    }
}

