/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core.bootup;

import io.avaje.classpath.scanner.ClassPathScanner;
import io.ebean.config.DatabaseConfig;
import io.ebeaninternal.server.core.ClassPathScanners;
import io.ebeaninternal.server.core.bootup.BootupClasses;
import io.ebeaninternal.server.core.bootup.DistillPackages;
import io.ebeaninternal.server.core.bootup.ManifestReader;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootupClassPathSearch {
    private static final Logger logger = LoggerFactory.getLogger(BootupClassPathSearch.class);
    private final List<String> packages;
    private final List<ClassPathScanner> scanners;

    public static BootupClasses search(DatabaseConfig config) {
        return new BootupClassPathSearch(config).getBootupClasses();
    }

    private BootupClassPathSearch(DatabaseConfig config) {
        Set<String> mfPackages = ManifestReader.create(config.getClassLoadConfig().getClassLoader()).read("META-INF/ebean.mf").read("ebean.mf").entityPackages();
        this.packages = DistillPackages.distill(config.getPackages(), mfPackages);
        this.scanners = ClassPathScanners.find(config);
    }

    private BootupClasses getBootupClasses() {
        try {
            BootupClasses bc = new BootupClasses();
            long st = System.currentTimeMillis();
            for (ClassPathScanner finder : this.scanners) {
                if (this.packages != null && !this.packages.isEmpty()) {
                    for (String packageName : this.packages) {
                        finder.scanForClasses(packageName, bc);
                    }
                    continue;
                }
                finder.scanForClasses("", bc);
            }
            long searchTime = System.currentTimeMillis() - st;
            logger.debug("Classpath search entities[{}] searchTime[{}] in packages[{}]", bc.getEntities().size(), searchTime, this.packages);
            return bc;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error in classpath search (looking for entities etc)", ex);
        }
    }
}

