/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.Database;
import io.ebean.meta.MetaCountMetric;
import io.ebean.meta.MetaMetric;
import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetaTimedMetric;
import io.ebean.meta.MetricData;
import io.ebean.meta.ServerMetrics;
import java.util.ArrayList;
import java.util.List;

class DumpMetricsData {
    private final Database database;
    private final List<MetricData> list = new ArrayList<MetricData>();

    DumpMetricsData(Database database) {
        this.database = database;
    }

    List<MetricData> data() {
        this.collect(this.database.getMetaInfoManager().collectMetrics());
        return this.list;
    }

    private void collect(ServerMetrics serverMetrics) {
        List<MetaTimedMetric> timedMetrics = serverMetrics.timedMetrics();
        List<MetaCountMetric> countMetrics = serverMetrics.countMetrics();
        List<MetaQueryMetric> queryMetrics = serverMetrics.queryMetrics();
        for (MetaTimedMetric metaTimedMetric : timedMetrics) {
            this.add(metaTimedMetric);
        }
        for (MetaCountMetric metaCountMetric : countMetrics) {
            this.addCount(metaCountMetric);
        }
        for (MetaQueryMetric metaQueryMetric : queryMetrics) {
            this.addQuery(metaQueryMetric);
        }
    }

    private MetricData create(MetaMetric metric) {
        MetricData data = new MetricData(metric.name());
        this.list.add(data);
        return data;
    }

    private void add(MetaTimedMetric metric) {
        MetricData data = this.create(metric);
        this.appendCounters(data, metric);
        data.setLoc(metric.location());
    }

    private void addCount(MetaCountMetric metric) {
        MetricData data = this.create(metric);
        data.setCount(metric.count());
    }

    private void addQuery(MetaQueryMetric metric) {
        MetricData data = this.create(metric);
        this.appendCounters(data, metric);
        this.appendLocationAndSql(data, metric);
        data.setHash(metric.hash());
    }

    private void appendLocationAndSql(MetricData data, MetaQueryMetric metric) {
        data.setLoc(metric.location());
        data.setSql(metric.sql());
    }

    private void appendCounters(MetricData data, MetaTimedMetric timedMetric) {
        data.setCount(timedMetric.count());
        data.setTotal(timedMetric.total());
        data.setMean(timedMetric.mean());
        data.setMax(timedMetric.max());
    }
}

