/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.meta.AbstractMetricVisitor;
import io.ebean.meta.BasicMetricVisitor;
import io.ebean.meta.MetaCountMetric;
import io.ebean.meta.MetaInfoManager;
import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetaQueryPlan;
import io.ebean.meta.MetaTimedMetric;
import io.ebean.meta.MetricData;
import io.ebean.meta.MetricVisitor;
import io.ebean.meta.QueryPlanInit;
import io.ebean.meta.QueryPlanRequest;
import io.ebean.meta.ServerMetrics;
import io.ebean.meta.ServerMetricsAsJson;
import io.ebeaninternal.server.core.DefaultServer;
import io.ebeaninternal.server.core.DumpMetricsData;
import io.ebeaninternal.server.core.DumpMetricsJson;
import java.util.List;

public class DefaultMetaInfoManager
implements MetaInfoManager {
    private final DefaultServer server;

    DefaultMetaInfoManager(DefaultServer server) {
        this.server = server;
    }

    @Override
    public List<MetaQueryPlan> queryPlanInit(QueryPlanInit initRequest) {
        return this.server.queryPlanInit(initRequest);
    }

    @Override
    public List<MetaQueryPlan> queryPlanCollectNow(QueryPlanRequest request) {
        return this.server.queryPlanCollectNow(request);
    }

    @Override
    public void visitMetrics(MetricVisitor visitor) {
        this.server.visitMetrics(visitor);
    }

    @Override
    public ServerMetrics collectMetrics() {
        return this.visitBasic();
    }

    @Override
    public ServerMetricsAsJson collectMetricsAsJson() {
        return new DumpMetricsJson(this.server);
    }

    @Override
    public List<MetricData> collectMetricsAsData() {
        return new DumpMetricsData(this.server).data();
    }

    @Override
    public BasicMetricVisitor visitBasic() {
        BasicMetricVisitor basic = new BasicMetricVisitor();
        this.visitMetrics(basic);
        return basic;
    }

    @Override
    public void resetAllMetrics() {
        this.server.visitMetrics(new ResetVisitor());
    }

    private static class ResetVisitor
    extends AbstractMetricVisitor {
        ResetVisitor() {
            super(true, true, true, true);
        }

        @Override
        public void visitTimed(MetaTimedMetric metric) {
        }

        @Override
        public void visitQuery(MetaQueryMetric metric) {
        }

        @Override
        public void visitCount(MetaCountMetric metric) {
        }
    }
}

