/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.EbeanServer;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.timezone.DataTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanRequest {
    static final Logger log = LoggerFactory.getLogger(BeanRequest.class);
    protected final SpiEbeanServer ebeanServer;
    protected SpiTransaction transaction;
    protected boolean createdTransaction;

    public BeanRequest(SpiEbeanServer ebeanServer, SpiTransaction t) {
        this.ebeanServer = ebeanServer;
        this.transaction = t;
    }

    public boolean createImplicitTransIfRequired() {
        if (this.transaction != null) {
            return false;
        }
        this.transaction = this.ebeanServer.currentServerTransaction();
        if (this.transaction == null || !this.transaction.isActive()) {
            this.transaction = this.ebeanServer.beginServerTransaction();
            this.createdTransaction = true;
        }
        return true;
    }

    public void commitTransIfRequired() {
        if (this.createdTransaction) {
            this.ebeanServer.commitTransaction();
        }
    }

    public void rollbackTransIfRequired() {
        if (this.createdTransaction) {
            try {
                this.ebeanServer.endTransaction();
            }
            catch (Exception e) {
                log.error("Error trying to rollback a transaction (after a prior exception thrown)", e);
            }
        }
    }

    public void clearTransIfRequired() {
        if (this.createdTransaction) {
            this.ebeanServer.clearServerTransaction();
        }
    }

    public EbeanServer getEbeanServer() {
        return this.ebeanServer;
    }

    public SpiEbeanServer getServer() {
        return this.ebeanServer;
    }

    public SpiTransaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(SpiTransaction transaction) {
        this.transaction = transaction;
    }

    public boolean isLogSql() {
        return this.transaction.isLogSql();
    }

    public boolean isLogSummary() {
        return this.transaction.isLogSummary();
    }

    public DataTimeZone getDataTimeZone() {
        return this.ebeanServer.getDataTimeZone();
    }
}

