/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.changelog;

import io.ebean.event.changelog.BeanChange;
import io.ebean.event.changelog.ChangeLogListener;
import io.ebean.event.changelog.ChangeSet;
import io.ebean.event.changelog.ChangeType;
import io.ebean.plugin.Plugin;
import io.ebean.plugin.SpiServer;
import io.ebeaninternal.server.changelog.ChangeJsonBuilder;
import java.io.StringWriter;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChangeLogListener
implements ChangeLogListener,
Plugin {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultChangeLogListener.class);
    private static final Logger changeLog = LoggerFactory.getLogger("io.ebean.ChangeLog");
    private ChangeJsonBuilder jsonBuilder;
    private int defaultBufferSize = 400;

    @Override
    public void configure(SpiServer server) {
        String bufferSize;
        this.jsonBuilder = new ChangeJsonBuilder(server.json());
        Properties properties = server.getServerConfig().getProperties();
        if (properties != null && (bufferSize = properties.getProperty("ebean.changeLog.bufferSize")) != null) {
            this.defaultBufferSize = Integer.parseInt(bufferSize);
        }
    }

    @Override
    public void online(boolean online) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void log(ChangeSet changeSet) {
        for (BeanChange beanChange : changeSet.getChanges()) {
            try {
                StringWriter writer = new StringWriter(this.getBufferSize(beanChange));
                this.jsonBuilder.writeBeanJson(writer, beanChange, changeSet);
                changeLog.info(writer.toString());
            }
            catch (Exception e) {
                logger.error("Exception logging beanChange " + beanChange.toString(), e);
            }
        }
    }

    private int getBufferSize(BeanChange beanChange) {
        return ChangeType.DELETE == beanChange.getEvent() ? 250 : this.defaultBufferSize;
    }
}

