/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.changelog;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.ebean.event.changelog.BeanChange;
import io.ebean.event.changelog.ChangeSet;
import io.ebean.event.changelog.ChangeType;
import io.ebean.text.json.JsonContext;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

class ChangeJsonBuilder {
    protected final JsonFactory jsonFactory = new JsonFactory();
    protected final JsonContext json;

    ChangeJsonBuilder(JsonContext json) {
        this.json = json;
    }

    void writeBeanJson(Writer writer, BeanChange bean, ChangeSet changeSet) throws IOException {
        try (JsonGenerator generator = this.jsonFactory.createGenerator(writer);){
            this.writeBeanChange(generator, bean, changeSet);
            generator.flush();
        }
    }

    private void writeBeanChange(JsonGenerator gen, BeanChange bean, ChangeSet changeSet) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField("ts", bean.getEventTime());
        gen.writeStringField("change", bean.getEvent().getCode());
        gen.writeStringField("type", bean.getType());
        gen.writeStringField("id", bean.getId().toString());
        if (bean.getTenantId() != null) {
            gen.writeStringField("tenantId", bean.getTenantId().toString());
        }
        this.writeBeanTransactionDetails(gen, changeSet);
        this.writeBeanValues(gen, bean);
        gen.writeEndObject();
    }

    private void writeBeanTransactionDetails(JsonGenerator gen, ChangeSet changeSet) throws IOException {
        Map<String, String> userContext;
        String userIpAddress;
        String userId;
        String source = changeSet.getSource();
        if (source != null) {
            gen.writeStringField("source", source);
        }
        if ((userId = changeSet.getUserId()) != null) {
            gen.writeStringField("userId", userId);
        }
        if ((userIpAddress = changeSet.getUserIpAddress()) != null) {
            gen.writeStringField("userIpAddress", userIpAddress);
        }
        if ((userContext = changeSet.getUserContext()) != null && !userContext.isEmpty()) {
            gen.writeObjectFieldStart("userContext");
            for (Map.Entry<String, String> entry : userContext.entrySet()) {
                gen.writeStringField(entry.getKey(), entry.getValue());
            }
            gen.writeEndObject();
        }
    }

    private void writeBeanValues(JsonGenerator gen, BeanChange bean) throws IOException {
        if (bean.getEvent() != ChangeType.DELETE) {
            gen.writeFieldName("data");
            gen.writeRaw(":");
            gen.writeRaw(bean.getData());
            String oldData = bean.getOldData();
            if (oldData != null) {
                gen.writeRaw(",\"oldData\":");
                gen.writeRaw(oldData);
            }
        }
    }
}

