/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.cache;

import io.ebean.annotation.Cache;
import io.ebean.annotation.CacheBeanTuning;
import io.ebean.annotation.CacheQueryTuning;
import io.ebean.cache.QueryCacheEntryValidate;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheConfig;
import io.ebean.cache.ServerCacheFactory;
import io.ebean.cache.ServerCacheOptions;
import io.ebean.cache.ServerCacheType;
import io.ebean.config.CurrentTenantProvider;
import io.ebean.meta.MetricVisitor;
import io.ebean.util.AnnotationUtil;
import io.ebeaninternal.server.cache.CacheManagerOptions;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultCacheHolder {
    private static final Logger log = LoggerFactory.getLogger("io.ebean.cache.ALL");
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentHashMap<String, ServerCache> allCaches = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<String>> collectIdCaches = new ConcurrentHashMap();
    private final ServerCacheFactory cacheFactory;
    private final ServerCacheOptions beanDefault;
    private final ServerCacheOptions queryDefault;
    private final CurrentTenantProvider tenantProvider;
    private final QueryCacheEntryValidate queryCacheEntryValidate;

    DefaultCacheHolder(CacheManagerOptions builder) {
        this.cacheFactory = builder.getCacheFactory();
        this.beanDefault = builder.getBeanDefault();
        this.queryDefault = builder.getQueryDefault();
        this.tenantProvider = builder.getCurrentTenantProvider();
        this.queryCacheEntryValidate = builder.getQueryCacheEntryValidate();
    }

    void visitMetrics(MetricVisitor visitor) {
        this.cacheFactory.visit(visitor);
        for (ServerCache serverCache : this.allCaches.values()) {
            serverCache.visit(visitor);
        }
    }

    ServerCache getCache(Class<?> beanType, ServerCacheType type) {
        return this.getCacheInternal(beanType, type, null);
    }

    ServerCache getCache(Class<?> beanType, String collectionProperty) {
        return this.getCacheInternal(beanType, ServerCacheType.COLLECTION_IDS, collectionProperty);
    }

    private String key(String beanName, ServerCacheType type) {
        return beanName + type.code();
    }

    private String key(String beanName, String collectionProperty, ServerCacheType type) {
        if (collectionProperty != null) {
            return beanName + "." + collectionProperty + type.code();
        }
        return beanName + type.code();
    }

    private ServerCache getCacheInternal(Class<?> beanType, ServerCacheType type, String collectionProperty) {
        String shortName = this.key(beanType.getSimpleName(), collectionProperty, type);
        String fullKey = this.key(beanType.getName(), collectionProperty, type);
        return this.allCaches.computeIfAbsent(fullKey, s2 -> this.createCache(beanType, type, fullKey, shortName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerCache createCache(Class<?> beanType, ServerCacheType type, String key, String shortName) {
        ServerCacheOptions options = this.getCacheOptions(beanType, type);
        if (type == ServerCacheType.COLLECTION_IDS) {
            this.lock.lock();
            try {
                this.collectIdCaches.computeIfAbsent(beanType.getName(), s2 -> new ConcurrentSkipListSet()).add(key);
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.cacheFactory.createCache(new ServerCacheConfig(type, key, shortName, options, this.tenantProvider, this.queryCacheEntryValidate));
    }

    void clearAll() {
        log.debug("clearAll");
        for (ServerCache serverCache : this.allCaches.values()) {
            serverCache.clear();
        }
    }

    public void clear(String name) {
        log.debug("clear {}", (Object)name);
        this.clearIfExists(this.key(name, ServerCacheType.QUERY));
        this.clearIfExists(this.key(name, ServerCacheType.BEAN));
        this.clearIfExists(this.key(name, ServerCacheType.NATURAL_KEY));
        Set<String> keys = this.collectIdCaches.get(name);
        if (keys != null) {
            for (String collectionIdKey : keys) {
                this.clearIfExists(collectionIdKey);
            }
        }
    }

    private void clearIfExists(String fullKey) {
        ServerCache cache = this.allCaches.get(fullKey);
        if (cache != null) {
            log.trace("clear cache {}", (Object)fullKey);
            cache.clear();
        }
    }

    ServerCacheOptions getCacheOptions(Class<?> beanType, ServerCacheType type) {
        if (type == ServerCacheType.QUERY) {
            return this.getQueryOptions(beanType);
        }
        return this.getBeanOptions(beanType);
    }

    private ServerCacheOptions getQueryOptions(Class<?> cls) {
        CacheQueryTuning tuning = AnnotationUtil.get(cls, CacheQueryTuning.class);
        if (tuning != null) {
            return new ServerCacheOptions(tuning).applyDefaults(this.queryDefault);
        }
        return this.queryDefault.copy();
    }

    private ServerCacheOptions getBeanOptions(Class<?> cls) {
        Cache cache = cls.getAnnotation(Cache.class);
        boolean nearCache = cache != null && cache.nearCache();
        CacheBeanTuning tuning = cls.getAnnotation(CacheBeanTuning.class);
        if (tuning != null) {
            return new ServerCacheOptions(nearCache, tuning).applyDefaults(this.beanDefault);
        }
        return this.beanDefault.copy(nearCache);
    }
}

