/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model;

import io.ebean.migration.MigrationVersion;
import io.ebeaninternal.dbmigration.migration.ChangeSet;
import io.ebeaninternal.dbmigration.migration.ChangeSetType;
import io.ebeaninternal.dbmigration.migration.DropColumn;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.migration.DropTable;
import io.ebeaninternal.dbmigration.migration.Migration;
import io.ebeaninternal.dbmigration.model.ModelContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class PendingDrops {
    private final LinkedHashMap<String, Entry> map = new LinkedHashMap();

    public void add(MigrationVersion version, ChangeSet changeSet) {
        Entry entry = this.map.computeIfAbsent(version.normalised(), k -> new Entry(version));
        entry.add(changeSet);
    }

    public List<String> pendingDrops() {
        ArrayList<String> versions = new ArrayList<String>();
        for (Entry value : this.map.values()) {
            if (!value.hasPendingDrops()) continue;
            versions.add(value.version.asString());
        }
        return versions;
    }

    public boolean appliedDropsFor(ChangeSet changeSet) {
        MigrationVersion version = MigrationVersion.parse(changeSet.getDropsFor());
        Entry entry = this.map.get(version.normalised());
        if (entry.removeDrops(changeSet)) {
            this.map.remove(version.normalised());
            return true;
        }
        return false;
    }

    public Migration migrationForVersion(String pendingVersion) {
        Entry entry = this.getEntry(pendingVersion);
        Migration migration = new Migration();
        Iterator<ChangeSet> it = entry.list.iterator();
        while (it.hasNext()) {
            ChangeSet changeSet = it.next();
            if (PendingDrops.isSuppressForever(changeSet)) continue;
            it.remove();
            changeSet.setType(ChangeSetType.APPLY);
            changeSet.setDropsFor(entry.version.asString());
            migration.getChangeSet().add(changeSet);
        }
        if (migration.getChangeSet().isEmpty()) {
            throw new IllegalArgumentException("The remaining pendingDrops changeSets in migration [" + pendingVersion + "] are suppressDropsForever=true and can't be applied");
        }
        if (!entry.containsSuppressForever()) {
            this.map.remove(entry.version.normalised());
        }
        return migration;
    }

    private Entry getEntry(String pendingVersion) {
        if ("next".equalsIgnoreCase(pendingVersion)) {
            Iterator<Entry> it = this.map.values().iterator();
            if (it.hasNext()) {
                return it.next();
            }
        } else {
            Entry remove = this.map.get(MigrationVersion.parse(pendingVersion).normalised());
            if (remove != null) {
                return remove;
            }
        }
        throw new IllegalArgumentException("No 'pendingDrops' changeSets for migration version [" + pendingVersion + "] found");
    }

    public void registerPendingHistoryDropColumns(ModelContainer newModel) {
        for (Entry entry : this.map.values()) {
            for (ChangeSet changeSet : entry.list) {
                newModel.registerPendingHistoryDropColumns(changeSet);
            }
        }
    }

    boolean testContainsEntryFor(MigrationVersion version) {
        return this.map.containsKey(version.normalised());
    }

    Entry testGetEntryFor(MigrationVersion version) {
        return this.map.get(version.normalised());
    }

    private static boolean isSuppressForever(ChangeSet next) {
        return Boolean.TRUE.equals(next.isSuppressDropsForever());
    }

    static class Entry {
        final MigrationVersion version;
        final List<ChangeSet> list = new ArrayList<ChangeSet>();

        Entry(MigrationVersion version) {
            this.version = version;
        }

        void add(ChangeSet changeSet) {
            this.list.add(changeSet);
        }

        boolean containsSuppressForever() {
            for (ChangeSet changeSet : this.list) {
                if (!PendingDrops.isSuppressForever(changeSet)) continue;
                return true;
            }
            return false;
        }

        boolean hasPendingDrops() {
            for (ChangeSet changeSet : this.list) {
                if (PendingDrops.isSuppressForever(changeSet)) continue;
                return true;
            }
            return false;
        }

        boolean removeDrops(ChangeSet appliedDrops) {
            Iterator<ChangeSet> iterator = this.list.iterator();
            while (iterator.hasNext()) {
                ChangeSet next = iterator.next();
                if (PendingDrops.isSuppressForever(next)) continue;
                this.removeMatchingChanges(next, appliedDrops);
                if (!next.getChangeSetChildren().isEmpty()) continue;
                iterator.remove();
            }
            return this.list.isEmpty();
        }

        private void removeMatchingChanges(ChangeSet pendingDrops, ChangeSet appliedDrops) {
            List<Object> pending = pendingDrops.getChangeSetChildren();
            Iterator<Object> iterator = pending.iterator();
            while (iterator.hasNext()) {
                Object pendingDrop = iterator.next();
                if (pendingDrop instanceof DropColumn && this.dropColumnIn((DropColumn)pendingDrop, appliedDrops)) {
                    iterator.remove();
                    continue;
                }
                if (pendingDrop instanceof DropTable && this.dropTableIn((DropTable)pendingDrop, appliedDrops)) {
                    iterator.remove();
                    continue;
                }
                if (!(pendingDrop instanceof DropHistoryTable) || !this.dropHistoryTableIn((DropHistoryTable)pendingDrop, appliedDrops)) continue;
                iterator.remove();
            }
        }

        private boolean dropHistoryTableIn(DropHistoryTable pendingDrop, ChangeSet appliedDrops) {
            for (Object o : appliedDrops.getChangeSetChildren()) {
                if (!(o instanceof DropHistoryTable) || !this.sameHistoryTable(pendingDrop, (DropHistoryTable)o)) continue;
                return true;
            }
            return false;
        }

        private boolean dropTableIn(DropTable pendingDrop, ChangeSet appliedDrops) {
            for (Object o : appliedDrops.getChangeSetChildren()) {
                if (!(o instanceof DropTable) || !this.sameTable(pendingDrop, (DropTable)o)) continue;
                return true;
            }
            return false;
        }

        private boolean dropColumnIn(DropColumn pendingDrop, ChangeSet appliedDrops) {
            for (Object o : appliedDrops.getChangeSetChildren()) {
                if (!(o instanceof DropColumn) || !this.sameColumn(pendingDrop, (DropColumn)o)) continue;
                return true;
            }
            return false;
        }

        private boolean sameHistoryTable(DropHistoryTable pendingDrop, DropHistoryTable o) {
            return pendingDrop.getBaseTable().equals(o.getBaseTable());
        }

        private boolean sameTable(DropTable pendingDrop, DropTable o) {
            return pendingDrop.getName().equals(o.getName());
        }

        private boolean sameColumn(DropColumn pending, DropColumn o) {
            return pending.getColumnName().equals(o.getColumnName()) && pending.getTableName().equals(o.getTableName());
        }
    }
}

